/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.common.mqtt.dao;

import java.time.Instant;
import net.solarnetwork.common.mqtt.MqttMessage;
import net.solarnetwork.common.mqtt.MqttProperties;
import net.solarnetwork.common.mqtt.MqttQos;
import net.solarnetwork.common.mqtt.dao.MqttMessageEntity;
import net.solarnetwork.dao.BasicLongEntity;

public class BasicMqttMessageEntity
extends BasicLongEntity
implements MqttMessageEntity {
    private static final long serialVersionUID = 5975450598082657522L;
    private final String destination;
    private final String topic;
    private final boolean retained;
    private final MqttQos qos;
    private final byte[] payload;

    public BasicMqttMessageEntity() {
        this(null, null, null, null, false, null, null);
    }

    public BasicMqttMessageEntity(Long id, Instant created, String destination, MqttMessage message) {
        this(id, created, destination, message.getTopic(), message.isRetained(), message.getQosLevel(), message.getPayload());
    }

    public BasicMqttMessageEntity(Long id, Instant created, String destination, String topic, boolean retained, MqttQos qos, byte[] payload) {
        super(id, created);
        this.destination = destination;
        this.topic = topic;
        this.retained = retained;
        this.qos = qos;
        this.payload = payload;
    }

    public static BasicMqttMessageEntity forMessage(String destination, MqttMessage message) {
        return new BasicMqttMessageEntity(null, Instant.now(), destination, message);
    }

    public BasicMqttMessageEntity clone() {
        return (BasicMqttMessageEntity)super.clone();
    }

    public BasicMqttMessageEntity withId(Long id) {
        return new BasicMqttMessageEntity(id, this.getCreated(), this.destination, this);
    }

    @Override
    public String getDestination() {
        return this.destination;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public boolean isRetained() {
        return this.retained;
    }

    @Override
    public MqttQos getQosLevel() {
        return this.qos;
    }

    @Override
    public byte[] getPayload() {
        return this.payload;
    }

    @Override
    public MqttProperties getProperties() {
        return null;
    }
}

