/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.ocpp.v16.jakarta.cs;

import java.time.Instant;
import java.util.UUID;
import net.solarnetwork.ocpp.domain.Measurand;
import net.solarnetwork.ocpp.domain.SampledValue;
import ocpp.v16.jakarta.cs.AuthorizationStatus;
import ocpp.v16.jakarta.cs.Location;
import ocpp.v16.jakarta.cs.Phase;
import ocpp.v16.jakarta.cs.ReadingContext;
import ocpp.v16.jakarta.cs.SampledValue;
import ocpp.v16.jakarta.cs.UnitOfMeasure;

public final class CentralSystemUtils {
    private CentralSystemUtils() {
    }

    public static AuthorizationStatus statusForStatus(net.solarnetwork.ocpp.domain.AuthorizationStatus status) {
        switch (status) {
            case Accepted: {
                return AuthorizationStatus.ACCEPTED;
            }
            case Blocked: {
                return AuthorizationStatus.BLOCKED;
            }
            case ConcurrentTx: {
                return AuthorizationStatus.CONCURRENT_TX;
            }
            case Expired: {
                return AuthorizationStatus.EXPIRED;
            }
        }
        return AuthorizationStatus.INVALID;
    }

    public static net.solarnetwork.ocpp.domain.SampledValue sampledValue(UUID chargeSessionId, Instant timestamp, SampledValue value) {
        SampledValue.Builder result = net.solarnetwork.ocpp.domain.SampledValue.builder().withSessionId(chargeSessionId).withTimestamp(timestamp).withContext(CentralSystemUtils.readingContext(value.getContext())).withLocation(CentralSystemUtils.location(value.getLocation())).withMeasurand(CentralSystemUtils.measurand(value.getMeasurand())).withPhase(CentralSystemUtils.phase(value.getPhase())).withUnit(CentralSystemUtils.unit(value.getUnit())).withValue(value.getValue());
        return result.build();
    }

    public static net.solarnetwork.ocpp.domain.UnitOfMeasure unit(UnitOfMeasure unit) {
        if (UnitOfMeasure.CELCIUS == unit) {
            return net.solarnetwork.ocpp.domain.UnitOfMeasure.Celsius;
        }
        try {
            return net.solarnetwork.ocpp.domain.UnitOfMeasure.valueOf((String)unit.value());
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return net.solarnetwork.ocpp.domain.UnitOfMeasure.Unknown;
        }
    }

    public static net.solarnetwork.ocpp.domain.Phase phase(Phase phase) {
        if (phase == null) {
            return null;
        }
        try {
            return net.solarnetwork.ocpp.domain.Phase.valueOf((String)phase.value().replace("-", ""));
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return net.solarnetwork.ocpp.domain.Phase.Unknown;
        }
    }

    public static Measurand measurand(ocpp.v16.jakarta.cs.Measurand measurand) {
        try {
            return Measurand.valueOf((String)measurand.value().replace(".", ""));
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return Measurand.Unknown;
        }
    }

    public static net.solarnetwork.ocpp.domain.Location location(Location location) {
        try {
            return net.solarnetwork.ocpp.domain.Location.valueOf((String)location.value());
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return net.solarnetwork.ocpp.domain.Location.Outlet;
        }
    }

    public static net.solarnetwork.ocpp.domain.ReadingContext readingContext(ReadingContext context) {
        try {
            return net.solarnetwork.ocpp.domain.ReadingContext.valueOf((String)context.value().replace(".", ""));
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return net.solarnetwork.ocpp.domain.ReadingContext.Unknown;
        }
    }
}

