/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.ocpp.v16.jakarta.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import com.fasterxml.jackson.module.jakarta.xmlbind.JakartaXmlBindAnnotationModule;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import java.text.DateFormat;
import net.solarnetwork.ocpp.json.ActionPayloadDecoder;
import net.solarnetwork.ocpp.xml.jakarta.support.JaxbUtils;
import net.solarnetwork.ocpp.xml.jakarta.support.SchemaValidationHelper;

public abstract class BaseActionPayloadDecoder
implements ActionPayloadDecoder {
    protected final ObjectMapper mapper;
    protected final SchemaValidationHelper schemaHelper;
    protected final JAXBContext jaxbContext;

    public static ObjectMapper defaultObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JakartaXmlBindAnnotationModule());
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.setDateFormat((DateFormat)new StdDateFormat().withColonInTimeZone(true));
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        return mapper;
    }

    public BaseActionPayloadDecoder(ObjectMapper mapper, Class<?> jaxbRegistry, String wsdlResource, ClassLoader classLoader) {
        if (mapper == null) {
            throw new IllegalArgumentException("The mapper parameter must not be null.");
        }
        this.mapper = mapper;
        try {
            this.jaxbContext = JaxbUtils.jaxbContextForRegistry(jaxbRegistry);
        }
        catch (JAXBException e) {
            throw new RuntimeException("Error setting up JAXBContext for message validation.", e);
        }
        this.schemaHelper = new SchemaValidationHelper(SchemaValidationHelper.schemaFromWsdl(wsdlResource, classLoader));
    }
}

