/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.ocpp.v16.jakarta.cs;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.solarnetwork.ocpp.domain.Action;
import net.solarnetwork.ocpp.domain.ActionMessage;
import net.solarnetwork.ocpp.domain.AuthorizationInfo;
import net.solarnetwork.ocpp.domain.ChargePointIdentity;
import net.solarnetwork.ocpp.domain.ChargeSession;
import net.solarnetwork.ocpp.domain.ChargeSessionEndInfo;
import net.solarnetwork.ocpp.domain.ChargeSessionEndReason;
import net.solarnetwork.ocpp.domain.ErrorCode;
import net.solarnetwork.ocpp.domain.ErrorCodeException;
import net.solarnetwork.ocpp.service.ActionMessageResultHandler;
import net.solarnetwork.ocpp.service.AuthorizationException;
import net.solarnetwork.ocpp.service.BaseActionMessageProcessor;
import net.solarnetwork.ocpp.service.cs.ChargeSessionManager;
import net.solarnetwork.ocpp.v16.jakarta.ActionErrorCode;
import net.solarnetwork.ocpp.v16.jakarta.CentralSystemAction;
import net.solarnetwork.ocpp.v16.jakarta.cs.CentralSystemUtils;
import net.solarnetwork.ocpp.xml.jakarta.support.XmlDateUtils;
import ocpp.v16.jakarta.cs.IdTagInfo;
import ocpp.v16.jakarta.cs.MeterValue;
import ocpp.v16.jakarta.cs.Reason;
import ocpp.v16.jakarta.cs.SampledValue;
import ocpp.v16.jakarta.cs.StopTransactionRequest;
import ocpp.v16.jakarta.cs.StopTransactionResponse;

public class StopTransactionProcessor
extends BaseActionMessageProcessor<StopTransactionRequest, StopTransactionResponse> {
    public static final Set<Action> SUPPORTED_ACTIONS = Collections.singleton(CentralSystemAction.StopTransaction);
    private final ChargeSessionManager chargeSessionManager;

    public StopTransactionProcessor(ChargeSessionManager chargeSessionManager) {
        super(StopTransactionRequest.class, StopTransactionResponse.class, SUPPORTED_ACTIONS);
        if (chargeSessionManager == null) {
            throw new IllegalArgumentException("The chargeSessionManager parameter must not be null.");
        }
        this.chargeSessionManager = chargeSessionManager;
    }

    public void processActionMessage(ActionMessage<StopTransactionRequest> message, ActionMessageResultHandler<StopTransactionRequest, StopTransactionResponse> resultHandler) {
        ChargePointIdentity chargePointId = message.getClientId();
        StopTransactionRequest req = (StopTransactionRequest)message.getMessage();
        if (req == null || chargePointId == null) {
            ErrorCodeException err = new ErrorCodeException((ErrorCode)ActionErrorCode.FormationViolation, "Missing StopTransactionRequest message.");
            resultHandler.handleActionMessageResult(message, null, (Throwable)err);
            return;
        }
        if (req.getTransactionId() < 1) {
            ErrorCodeException err = new ErrorCodeException((ErrorCode)ActionErrorCode.PropertyConstraintViolation, "The transaction ID must be greater than 0.");
            resultHandler.handleActionMessageResult(message, null, (Throwable)err);
            return;
        }
        String txId = String.valueOf(req.getTransactionId());
        try {
            ChargeSession session = this.chargeSessionManager.getActiveChargingSession(chargePointId, txId);
            if (session == null) {
                resultHandler.handleActionMessageResult(message, (Object)new StopTransactionResponse(), null);
                return;
            }
            ChargeSessionEndInfo info = ChargeSessionEndInfo.builder().withChargePointId(chargePointId).withAuthorizationId(req.getIdTag()).withTransactionId(txId).withMeterEnd((long)req.getMeterStop()).withTimestampEnd(XmlDateUtils.timestamp(req.getTimestamp(), Instant::now)).withReason(StopTransactionProcessor.reason(req.getReason())).withTransactionData(this.sampledValues((UUID)session.getId(), req.getTransactionData())).build();
            this.log.info("Received StopTransaction request: {}", (Object)info);
            AuthorizationInfo authInfo = this.chargeSessionManager.endChargingSession(info);
            IdTagInfo tagInfo = null;
            if (authInfo != null) {
                tagInfo = new IdTagInfo();
                tagInfo.setStatus(CentralSystemUtils.statusForStatus(authInfo.getStatus()));
            }
            StopTransactionResponse res = new StopTransactionResponse();
            res.setIdTagInfo(tagInfo);
            resultHandler.handleActionMessageResult(message, (Object)res, null);
        }
        catch (AuthorizationException e) {
            IdTagInfo tagInfo = new IdTagInfo();
            tagInfo.setStatus(CentralSystemUtils.statusForStatus(e.getInfo().getStatus()));
            StopTransactionResponse res = new StopTransactionResponse();
            res.setIdTagInfo(tagInfo);
            resultHandler.handleActionMessageResult(message, (Object)res, null);
        }
        catch (Throwable t) {
            this.log.error("Exception handling StopTransactionRequest: {}", (Object)t.toString(), (Object)t);
            ErrorCodeException err = new ErrorCodeException((ErrorCode)ActionErrorCode.InternalError, "Internal error: " + t.getMessage());
            resultHandler.handleActionMessageResult(message, null, (Throwable)err);
        }
    }

    private static ChargeSessionEndReason reason(Reason reason) {
        if (reason == null) {
            return ChargeSessionEndReason.Local;
        }
        try {
            return ChargeSessionEndReason.valueOf((String)reason.value());
        }
        catch (IllegalArgumentException e) {
            return ChargeSessionEndReason.Unknown;
        }
    }

    private List<net.solarnetwork.ocpp.domain.SampledValue> sampledValues(UUID chargeSessionId, List<MeterValue> transactionData) {
        ArrayList<net.solarnetwork.ocpp.domain.SampledValue> result = null;
        if (transactionData != null && !transactionData.isEmpty()) {
            for (MeterValue v : transactionData) {
                if (v.getSampledValue() == null || v.getSampledValue().isEmpty()) continue;
                Instant ts = XmlDateUtils.timestamp(v.getTimestamp(), Instant::now);
                for (SampledValue sv : v.getSampledValue()) {
                    if (result == null) {
                        result = new ArrayList<net.solarnetwork.ocpp.domain.SampledValue>(16);
                    }
                    result.add(CentralSystemUtils.sampledValue(chargeSessionId, ts, sv));
                }
            }
        }
        return result;
    }
}

