/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.ocpp.xml.jakarta.support;

import java.time.Instant;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.function.Supplier;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public final class XmlDateUtils {
    public static final DatatypeFactory DATATYPE_FACTORY = XmlDateUtils.defaultDatatypeFactory();
    private static final GregorianCalendar UTC_CALENDAR = new GregorianCalendar(TimeZone.getTimeZone("UTC"));

    private XmlDateUtils() {
    }

    private static DatatypeFactory defaultDatatypeFactory() {
        try {
            return DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static XMLGregorianCalendar newXmlCalendar() {
        return XmlDateUtils.newXmlCalendar(System.currentTimeMillis());
    }

    public static XMLGregorianCalendar newXmlCalendar(long date) {
        return XmlDateUtils.newXmlCalendar(DATATYPE_FACTORY, date);
    }

    public static final XMLGregorianCalendar newXmlCalendar(DatatypeFactory datatypeFactory, long date) {
        GregorianCalendar now = (GregorianCalendar)UTC_CALENDAR.clone();
        now.setTimeInMillis(date);
        return datatypeFactory.newXMLGregorianCalendar(now);
    }

    public static XMLGregorianCalendar newXmlCalendar(int year, int month, int day, int hour, int minute, int second, int millisecond) {
        return XmlDateUtils.newXmlCalendar(DATATYPE_FACTORY, year, month, day, hour, minute, second, millisecond);
    }

    public static XMLGregorianCalendar newXmlCalendar(DatatypeFactory datatypeFactory, int year, int month, int day, int hour, int minute, int second, int millisecond) {
        GregorianCalendar cal = (GregorianCalendar)UTC_CALENDAR.clone();
        cal.set(year, month - 1, day, hour, minute, second);
        cal.set(14, millisecond);
        return datatypeFactory.newXMLGregorianCalendar(cal);
    }

    public static Instant timestamp(XMLGregorianCalendar cal, Supplier<Instant> defaultSupplier) {
        return cal != null ? Instant.ofEpochMilli(cal.toGregorianCalendar().getTimeInMillis()) : (defaultSupplier != null ? defaultSupplier.get() : null);
    }
}

