/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.ocpp.v201.service;

import java.time.Clock;
import java.util.Collections;
import java.util.Set;
import net.solarnetwork.ocpp.domain.ActionMessage;
import net.solarnetwork.ocpp.domain.ChargePoint;
import net.solarnetwork.ocpp.domain.ChargePointInfo;
import net.solarnetwork.ocpp.domain.ErrorCode;
import net.solarnetwork.ocpp.domain.ErrorCodeException;
import net.solarnetwork.ocpp.service.ActionMessageResultHandler;
import net.solarnetwork.ocpp.service.BaseActionMessageProcessor;
import net.solarnetwork.ocpp.service.cs.ChargePointManager;
import net.solarnetwork.ocpp.v201.domain.Action;
import net.solarnetwork.ocpp.v201.domain.ActionErrorCode;
import net.solarnetwork.util.ObjectUtils;
import ocpp.v201.BootNotificationRequest;
import ocpp.v201.BootNotificationResponse;
import ocpp.v201.ChargingStation;
import ocpp.v201.Modem;
import ocpp.v201.RegistrationStatusEnum;

public class BootNotificationProcessor
extends BaseActionMessageProcessor<BootNotificationRequest, BootNotificationResponse> {
    public static final Set<net.solarnetwork.ocpp.domain.Action> SUPPORTED_ACTIONS = Collections.singleton(Action.BootNotification);
    public static final int DEFAULT_HEARTBEAT_INTERVAL_SECONDS = 300;
    private final Clock clock;
    private final ChargePointManager chargePointManager;
    private int heartbeatIntervalSeconds = 300;

    public BootNotificationProcessor(Clock clock, ChargePointManager chargePointManager) {
        super(BootNotificationRequest.class, BootNotificationResponse.class, SUPPORTED_ACTIONS);
        if (chargePointManager == null) {
            throw new IllegalArgumentException("The chargePointManager parameter must not be null.");
        }
        this.clock = (Clock)ObjectUtils.requireNonNullArgument((Object)clock, (String)"clock");
        this.chargePointManager = (ChargePointManager)ObjectUtils.requireNonNullArgument((Object)chargePointManager, (String)"chargePointManager");
    }

    public void processActionMessage(ActionMessage<BootNotificationRequest> message, ActionMessageResultHandler<BootNotificationRequest, BootNotificationResponse> resultHandler) {
        BootNotificationRequest req = (BootNotificationRequest)message.getMessage();
        if (req == null) {
            ErrorCodeException err = new ErrorCodeException((ErrorCode)ActionErrorCode.FormatViolation, "Missing BootNotificationRequest message.");
            resultHandler.handleActionMessageResult(message, null, (Throwable)err);
            return;
        }
        ChargePointInfo info = new ChargePointInfo(message.getClientId().getIdentifier());
        if (req.getChargingStation() != null) {
            ChargingStation station = req.getChargingStation();
            info.setChargePointVendor(station.getVendorName());
            info.setChargePointModel(station.getModel());
            info.setChargePointSerialNumber(station.getSerialNumber());
            info.setFirmwareVersion(station.getFirmwareVersion());
            if (station.getModem() != null) {
                Modem modem = station.getModem();
                info.setIccid(modem.getIccid());
                info.setImsi(modem.getImsi());
            }
        }
        try {
            ChargePoint cp = this.chargePointManager.registerChargePoint(message.getClientId(), info);
            BootNotificationResponse res = new BootNotificationResponse();
            res.setCurrentTime(this.clock.instant());
            if (cp.getRegistrationStatus() != null) {
                switch (cp.getRegistrationStatus()) {
                    case Accepted: {
                        res.setStatus(RegistrationStatusEnum.ACCEPTED);
                        break;
                    }
                    case Rejected: {
                        res.setStatus(RegistrationStatusEnum.REJECTED);
                        break;
                    }
                    default: {
                        res.setStatus(RegistrationStatusEnum.PENDING);
                        break;
                    }
                }
            } else {
                res.setStatus(RegistrationStatusEnum.PENDING);
            }
            res.setInterval(Integer.valueOf(this.getHeartbeatIntervalSeconds()));
            resultHandler.handleActionMessageResult(message, (Object)res, null);
        }
        catch (Throwable t) {
            ErrorCodeException err = new ErrorCodeException((ErrorCode)ActionErrorCode.InternalError, "Internal error: " + t.getMessage());
            resultHandler.handleActionMessageResult(message, null, (Throwable)err);
        }
    }

    public int getHeartbeatIntervalSeconds() {
        return this.heartbeatIntervalSeconds;
    }

    public void setHeartbeatIntervalSeconds(int heartbeatIntervalSeconds) {
        this.heartbeatIntervalSeconds = heartbeatIntervalSeconds;
    }
}

