/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.ocpp.v201.service;

import java.util.Collections;
import java.util.Set;
import net.solarnetwork.ocpp.domain.ActionMessage;
import net.solarnetwork.ocpp.service.ActionMessageResultHandler;
import net.solarnetwork.ocpp.service.BaseActionMessageProcessor;
import net.solarnetwork.ocpp.v201.domain.Action;
import ocpp.v201.DataTransferRequest;
import ocpp.v201.DataTransferResponse;
import ocpp.v201.DataTransferStatusEnum;

public class DataTransferProcessor
extends BaseActionMessageProcessor<DataTransferRequest, DataTransferResponse> {
    public static final Set<net.solarnetwork.ocpp.domain.Action> SUPPORTED_ACTIONS = Collections.singleton(Action.DataTransfer);

    public DataTransferProcessor() {
        super(DataTransferRequest.class, DataTransferResponse.class, SUPPORTED_ACTIONS);
    }

    public void processActionMessage(ActionMessage<DataTransferRequest> message, ActionMessageResultHandler<DataTransferRequest, DataTransferResponse> resultHandler) {
        DataTransferRequest req = (DataTransferRequest)message.getMessage();
        this.log.debug("OCPP DataTransfer received from {}; message ID = {}; vendor ID = {}; data = {}", new Object[]{message.getClientId(), req.getMessageId(), req.getVendorId(), req.getData()});
        DataTransferResponse res = new DataTransferResponse();
        res.setStatus(DataTransferStatusEnum.REJECTED);
        resultHandler.handleActionMessageResult(message, (Object)res, null);
    }
}

