/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.ocpp.v201.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.solarnetwork.codec.JsonUtils;
import net.solarnetwork.ocpp.domain.ActionMessage;
import net.solarnetwork.ocpp.domain.ChargePointIdentity;
import net.solarnetwork.ocpp.domain.ErrorCode;
import net.solarnetwork.ocpp.domain.ErrorCodeException;
import net.solarnetwork.ocpp.service.ActionMessageResultHandler;
import net.solarnetwork.ocpp.service.BaseActionMessageProcessor;
import net.solarnetwork.ocpp.service.cs.ChargeSessionManager;
import net.solarnetwork.ocpp.v201.domain.Action;
import net.solarnetwork.ocpp.v201.domain.ActionErrorCode;
import net.solarnetwork.ocpp.v201.util.OcppUtils;
import net.solarnetwork.util.ObjectUtils;
import ocpp.v201.MeterValue;
import ocpp.v201.MeterValuesRequest;
import ocpp.v201.MeterValuesResponse;

public class MeterValuesProcessor
extends BaseActionMessageProcessor<MeterValuesRequest, MeterValuesResponse> {
    public static final Set<net.solarnetwork.ocpp.domain.Action> SUPPORTED_ACTIONS = Collections.singleton(Action.MeterValues);
    private final ChargeSessionManager chargeSessionManager;

    public MeterValuesProcessor(ChargeSessionManager chargeSessionManager) {
        super(MeterValuesRequest.class, MeterValuesResponse.class, SUPPORTED_ACTIONS);
        this.chargeSessionManager = (ChargeSessionManager)ObjectUtils.requireNonNullArgument((Object)chargeSessionManager, (String)"chargeSessionManager");
    }

    public void processActionMessage(ActionMessage<MeterValuesRequest> message, ActionMessageResultHandler<MeterValuesRequest, MeterValuesResponse> resultHandler) {
        ChargePointIdentity chargePointId = message.getClientId();
        MeterValuesRequest req = (MeterValuesRequest)message.getMessage();
        if (req == null || chargePointId == null) {
            ErrorCodeException err = new ErrorCodeException((ErrorCode)ActionErrorCode.FormatViolation, "Missing MeterValuesRequest message.");
            resultHandler.handleActionMessageResult(message, null, (Throwable)err);
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Received MeterValues req: {}", (Object)JsonUtils.getJSONString((Object)req, (String)"{}"));
        }
        try {
            List values = req.getMeterValue();
            ArrayList newReadings = new ArrayList();
            if (values != null && !values.isEmpty()) {
                for (MeterValue mv : values) {
                    mv.getSampledValue().stream().map(v -> OcppUtils.sampledValue(null, mv.getTimestamp(), v)).forEach(newReadings::add);
                }
            }
            if (!newReadings.isEmpty()) {
                this.log.debug("Saving charge point {} EVSE {} readings: {}", new Object[]{chargePointId, req.getEvseId(), newReadings});
                this.chargeSessionManager.addChargingSessionReadings(chargePointId, req.getEvseId(), null, newReadings);
            }
            resultHandler.handleActionMessageResult(message, (Object)new MeterValuesResponse(), null);
        }
        catch (Throwable t) {
            ErrorCodeException err = new ErrorCodeException((ErrorCode)ActionErrorCode.InternalError, "Internal error: " + t.getMessage());
            resultHandler.handleActionMessageResult(message, null, (Throwable)err);
        }
    }
}

