/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.ocpp.dao;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.Callable;
import net.solarnetwork.ocpp.dao.ChargeSessionDao;
import net.solarnetwork.service.OptionalService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PurgePostedChargeSessionsTask
implements Callable<Integer>,
Runnable {
    public static final int DEFAULT_EXPIRATION_HOURS = 4;
    private OptionalService<ChargeSessionDao> chargeSessionDao;
    private int expirationHours = 4;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public void run() {
        try {
            this.call();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Integer call() throws Exception {
        ChargeSessionDao dao;
        ChargeSessionDao chargeSessionDao = dao = this.chargeSessionDao != null ? (ChargeSessionDao)this.chargeSessionDao.service() : null;
        if (this.chargeSessionDao == null) {
            this.log.debug("No ChargeSessionDao available, cannot purge posted charge sessions.");
            return 0;
        }
        Instant ts = Instant.now().minus(this.expirationHours, ChronoUnit.HOURS);
        this.log.debug("Looking for OCPP posted charge sessions older than {} hours to purge (older that {})...", (Object)this.expirationHours, (Object)ts);
        int result = dao.deletePostedChargeSessions(ts);
        this.log.info("Purged {} posted OCPP charge sessions more than {} hours old.", (Object)result, (Object)this.expirationHours);
        return result;
    }

    public void setChargeSessionDao(OptionalService<ChargeSessionDao> chargeSessionDao) {
        this.chargeSessionDao = chargeSessionDao;
    }

    public int getExpirationHours() {
        return this.expirationHours;
    }

    public void setExpirationHours(int expirationHours) {
        this.expirationHours = expirationHours;
    }
}

