/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.ocpp.domain;

import java.time.Instant;
import java.util.Objects;
import net.solarnetwork.dao.BasicLongEntity;
import net.solarnetwork.domain.Differentiable;

public class Authorization
extends BasicLongEntity
implements Differentiable<Authorization> {
    private static final long serialVersionUID = -540993930373637753L;
    private String token;
    private boolean enabled;
    private Instant expiryDate;
    private String parentId;

    public Authorization() {
    }

    public Authorization(Long id) {
        this(id, Instant.now());
    }

    public Authorization(Long id, Instant created) {
        super(id, created);
    }

    public Authorization(Instant created, String token) {
        super(null, created);
        this.setToken(token);
    }

    public Authorization(Authorization other) {
        this((Long)other.getId(), other.getCreated());
        this.token = other.token;
        this.enabled = other.enabled;
        this.expiryDate = other.expiryDate;
        this.parentId = other.parentId;
    }

    public boolean isSameAs(Authorization other) {
        if (other == null) {
            return false;
        }
        return this.enabled == other.enabled && Objects.equals(this.token, other.token) && Objects.equals(this.expiryDate, other.expiryDate) && Objects.equals(this.parentId, other.parentId);
    }

    public boolean differsFrom(Authorization other) {
        return !this.isSameAs(other);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Authorization{id=");
        builder.append(this.getId());
        builder.append(", ");
        if (this.token != null) {
            builder.append("token=");
            builder.append(this.token);
            builder.append(", ");
        }
        if (this.expiryDate != null) {
            builder.append("expiryDate=");
            builder.append(this.expiryDate);
            builder.append(", ");
        }
        if (this.parentId != null) {
            builder.append("parentId=");
            builder.append(this.parentId);
            builder.append(", ");
        }
        builder.append("}");
        return builder.toString();
    }

    public boolean isExpired() {
        return this.expiryDate != null && this.expiryDate.isBefore(Instant.now());
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Instant getExpiryDate() {
        return this.expiryDate;
    }

    public void setExpiryDate(Instant expiryDate) {
        this.expiryDate = expiryDate;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }
}

