/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.ocpp.domain;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.Instant;
import net.solarnetwork.ocpp.domain.AuthorizationStatus;

@JsonDeserialize(builder=Builder.class)
public class AuthorizationInfo {
    private final String id;
    private final AuthorizationStatus status;
    private final Instant expiryDate;
    private final String parentId;

    public AuthorizationInfo(String id, AuthorizationStatus status) {
        this(id, status, null, null);
    }

    public AuthorizationInfo(String id, AuthorizationStatus status, Instant expiryDate, String parentId) {
        this.id = id;
        this.status = status;
        this.expiryDate = expiryDate;
        this.parentId = parentId;
    }

    private AuthorizationInfo(Builder builder) {
        this(builder.id, builder.status, builder.expiryDate, builder.parentId);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AuthorizationInfo{");
        if (this.id != null) {
            builder.append("id=");
            builder.append(this.id);
            builder.append(", ");
        }
        if (this.status != null) {
            builder.append("status=");
            builder.append((Object)this.status);
            builder.append(", ");
        }
        if (this.expiryDate != null) {
            builder.append("expiryDate=");
            builder.append(this.expiryDate);
            builder.append(", ");
        }
        if (this.parentId != null) {
            builder.append("parentId=");
            builder.append(this.parentId);
        }
        builder.append("}");
        return builder.toString();
    }

    public String getId() {
        return this.id;
    }

    public AuthorizationStatus getStatus() {
        return this.status;
    }

    public Instant getExpiryDate() {
        return this.expiryDate;
    }

    public String getParentId() {
        return this.parentId;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private AuthorizationStatus status;
        private Instant expiryDate;
        private String parentId;

        private Builder() {
        }

        private Builder(AuthorizationInfo info) {
            this.id = info.id;
            this.status = info.status;
            this.expiryDate = info.expiryDate;
            this.parentId = info.parentId;
        }

        public Builder withId(String id) {
            this.id = id;
            return this;
        }

        public Builder withStatus(AuthorizationStatus status) {
            this.status = status;
            return this;
        }

        public Builder withExpiryDate(Instant expiryDate) {
            this.expiryDate = expiryDate;
            return this;
        }

        public Builder withParentId(String parentId) {
            this.parentId = parentId;
            return this;
        }

        public AuthorizationInfo build() {
            return new AuthorizationInfo(this);
        }
    }
}

