/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.ocpp.domain;

import net.solarnetwork.domain.CodedValue;

public enum AuthorizationStatus implements CodedValue
{
    None(0),
    Accepted(1),
    Blocked(2),
    Expired(3),
    Invalid(4),
    ConcurrentTx(5),
    NoCredit(6),
    NotAllowedTypeEVSE(7),
    NotAtThisLocation(8),
    NotAtThisTime(9),
    Unknown(10);

    private final byte code;

    private AuthorizationStatus(int code) {
        this.code = (byte)code;
    }

    public int getCode() {
        return this.code & 0xFF;
    }

    public static AuthorizationStatus forCode(int code) {
        switch (code) {
            case 1: {
                return Accepted;
            }
            case 2: {
                return Blocked;
            }
            case 3: {
                return Expired;
            }
            case 4: {
                return Invalid;
            }
            case 5: {
                return ConcurrentTx;
            }
            case 6: {
                return NoCredit;
            }
            case 7: {
                return NotAllowedTypeEVSE;
            }
            case 8: {
                return NotAtThisLocation;
            }
            case 9: {
                return NotAtThisTime;
            }
            case 10: {
                return Unknown;
            }
        }
        return None;
    }
}

