/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.ocpp.domain;

import java.util.UUID;
import net.solarnetwork.ocpp.domain.Action;
import net.solarnetwork.ocpp.domain.ActionMessage;
import net.solarnetwork.ocpp.domain.ChargePointIdentity;

public class BasicActionMessage<T>
implements ActionMessage<T> {
    private final ChargePointIdentity clientId;
    private final String messageId;
    private final Action action;
    private final T message;

    public BasicActionMessage(ChargePointIdentity clientId, Action action, T message) {
        this(clientId, UUID.randomUUID().toString(), action, message);
    }

    public BasicActionMessage(ChargePointIdentity clientId, String messageId, Action action, T message) {
        this.clientId = clientId;
        this.messageId = messageId;
        this.action = action;
        this.message = message;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BasicActionMessage{");
        if (this.clientId != null) {
            builder.append("clientId=");
            builder.append(this.clientId);
            builder.append(", ");
        }
        if (this.messageId != null) {
            builder.append("messageId=");
            builder.append(this.messageId);
            builder.append(", ");
        }
        if (this.action != null) {
            builder.append("action=");
            builder.append(this.action);
            builder.append(", ");
        }
        if (this.message != null) {
            builder.append("message=");
            builder.append(this.message);
        }
        builder.append("}");
        return builder.toString();
    }

    @Override
    public ChargePointIdentity getClientId() {
        return this.clientId;
    }

    @Override
    public String getMessageId() {
        return this.messageId;
    }

    @Override
    public Action getAction() {
        return this.action;
    }

    @Override
    public T getMessage() {
        return this.message;
    }
}

