/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.ocpp.domain;

import java.time.Instant;
import java.util.Objects;
import net.solarnetwork.dao.BasicLongEntity;
import net.solarnetwork.domain.Differentiable;
import net.solarnetwork.ocpp.domain.ChargePointIdentity;
import net.solarnetwork.ocpp.domain.ChargePointInfo;
import net.solarnetwork.ocpp.domain.RegistrationStatus;

public class ChargePoint
extends BasicLongEntity
implements Differentiable<ChargePoint> {
    private static final long serialVersionUID = -5780143529087352852L;
    private final ChargePointInfo info;
    private RegistrationStatus registrationStatus;
    private boolean enabled;
    private int connectorCount;

    public ChargePoint() {
        this.info = new ChargePointInfo();
    }

    public ChargePoint(Long id) {
        this(id, Instant.now());
    }

    public ChargePoint(Long id, Instant created) {
        this(id, created, new ChargePointInfo());
    }

    public ChargePoint(Long id, Instant created, ChargePointInfo info) {
        super(id, created);
        if (info == null) {
            throw new IllegalArgumentException("The info parameter must not be null.");
        }
        this.setRegistrationStatus(RegistrationStatus.Pending);
        this.info = info;
    }

    public ChargePoint(Instant created, String identifier, String chargePointVendor, String chargePointModel) {
        this(null, created, new ChargePointInfo(identifier, chargePointVendor, chargePointModel));
    }

    public ChargePoint(ChargePoint other) {
        this((Long)other.getId(), other.getCreated(), new ChargePointInfo(other.getInfo()));
        this.registrationStatus = other.registrationStatus;
        this.enabled = other.enabled;
        this.connectorCount = other.connectorCount;
    }

    public ChargePointIdentity chargePointIdentity() {
        return new ChargePointIdentity(this.getInfo().getId(), "");
    }

    public boolean isSameAs(ChargePoint other) {
        if (other == null) {
            return false;
        }
        return this.info.isSameAs(other.info) && Objects.equals((Object)this.registrationStatus, (Object)other.registrationStatus) && this.enabled == other.enabled && this.connectorCount == other.connectorCount;
    }

    public boolean differsFrom(ChargePoint other) {
        return !this.isSameAs(other);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ChargePoint{");
        if (this.getId() != null) {
            builder.append("id=");
            builder.append(this.getId());
            builder.append(", ");
        }
        if (this.registrationStatus != null) {
            builder.append("registrationStatus=");
            builder.append((Object)this.registrationStatus);
            builder.append(", ");
        }
        builder.append("enabled=");
        builder.append(this.enabled);
        builder.append(", connectorCount=");
        builder.append(this.connectorCount);
        builder.append(", info=");
        builder.append(this.info);
        builder.append("}");
        return builder.toString();
    }

    public void copyInfoFrom(ChargePointInfo info) {
        this.info.copyFrom(info);
    }

    public ChargePointInfo getInfo() {
        return this.info;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public RegistrationStatus getRegistrationStatus() {
        return this.registrationStatus;
    }

    public void setRegistrationStatus(RegistrationStatus registrationStatus) {
        this.registrationStatus = registrationStatus;
    }

    public int getConnectorCount() {
        return this.connectorCount;
    }

    public void setConnectorCount(int connectorCount) {
        this.connectorCount = connectorCount;
    }
}

