/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.ocpp.domain;

import java.io.Serializable;
import java.util.Objects;

public class ChargePointConnectorKey
implements Serializable,
Cloneable,
Comparable<ChargePointConnectorKey> {
    private static final long serialVersionUID = 1143142263454730088L;
    private final long chargePointId;
    private final int evseId;
    private final int connectorId;

    public static ChargePointConnectorKey keyFor(long chargePointId, int connectorId) {
        return new ChargePointConnectorKey(chargePointId, connectorId);
    }

    public static ChargePointConnectorKey keyFor(long chargePointId, int evseId, int connectorId) {
        return new ChargePointConnectorKey(chargePointId, evseId, connectorId);
    }

    public ChargePointConnectorKey(long chargePointId, int connectorId) {
        this(chargePointId, 0, connectorId);
    }

    public ChargePointConnectorKey(long chargePointId, int evseId, int connectorId) {
        this.chargePointId = chargePointId;
        this.evseId = evseId;
        this.connectorId = connectorId;
    }

    @Override
    public int compareTo(ChargePointConnectorKey o) {
        int result = Long.compare(this.chargePointId, o.chargePointId);
        if (result == 0) {
            result = Integer.compare(this.evseId, o.evseId);
        }
        if (result == 0) {
            result = Integer.compare(this.connectorId, o.connectorId);
        }
        return result;
    }

    public ChargePointConnectorKey clone() {
        try {
            return (ChargePointConnectorKey)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        return Objects.hash(this.chargePointId, this.evseId, this.connectorId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ChargePointConnectorKey)) {
            return false;
        }
        ChargePointConnectorKey other = (ChargePointConnectorKey)obj;
        return Objects.equals(this.chargePointId, other.chargePointId) && this.evseId == other.evseId && this.connectorId == other.connectorId;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ChargePointConnectorKey{chargePointId=");
        builder.append(this.chargePointId);
        builder.append(", evseId=");
        builder.append(this.evseId);
        builder.append(", connectorId=");
        builder.append(this.connectorId);
        builder.append("}");
        return builder.toString();
    }

    public long getChargePointId() {
        return this.chargePointId;
    }

    public int getEvseId() {
        return this.evseId;
    }

    public int getConnectorId() {
        return this.connectorId;
    }
}

