/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.ocpp.domain;

import net.solarnetwork.domain.CodedValue;

public enum ChargePointErrorCode implements CodedValue
{
    Unknown(0),
    ConnectorLockFailure(1),
    HighTemperature(2),
    Mode3Error(3),
    NoError(4),
    PowerMeterFailure(5),
    PowerSwitchFailure(6),
    ReaderFailure(7),
    ResetFailure(8),
    GroundFailure(9),
    OverCurrentFailure(10),
    UnderVoltage(11),
    WeakSignal(12),
    OtherError(13),
    EVCommunicationError(14),
    InternalError(15),
    LocalListConflict(16),
    OverVoltage(17);

    private final byte code;

    private ChargePointErrorCode(int code) {
        this.code = (byte)code;
    }

    public int getCode() {
        return this.code & 0xFF;
    }

    public static ChargePointErrorCode forCode(int code) {
        byte c = (byte)code;
        for (ChargePointErrorCode v : ChargePointErrorCode.values()) {
            if (v.code != c) continue;
            return v;
        }
        return Unknown;
    }
}

