/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.ocpp.domain;

import java.util.Objects;

public class ChargePointInfo {
    private String id;
    private String chargePointVendor;
    private String chargePointModel;
    private String chargePointSerialNumber;
    private String chargeBoxSerialNumber;
    private String firmwareVersion;
    private String iccid;
    private String imsi;
    private String meterType;
    private String meterSerialNumber;

    public ChargePointInfo() {
    }

    public ChargePointInfo(String id) {
        this.setId(id);
    }

    public ChargePointInfo(String id, String chargePointVendor, String chargePointModel) {
        this.setId(id);
        this.setChargePointVendor(chargePointVendor);
        this.setChargePointModel(chargePointModel);
    }

    public ChargePointInfo(ChargePointInfo other) {
        this.copyFrom(other);
    }

    public void copyFrom(ChargePointInfo other) {
        if (other == null) {
            return;
        }
        this.id = other.id;
        this.chargePointVendor = other.chargePointVendor;
        this.chargePointModel = other.chargePointModel;
        this.chargePointSerialNumber = other.chargePointSerialNumber;
        this.chargeBoxSerialNumber = other.chargeBoxSerialNumber;
        this.firmwareVersion = other.firmwareVersion;
        this.iccid = other.iccid;
        this.imsi = other.imsi;
        this.meterType = other.meterType;
        this.meterSerialNumber = other.meterSerialNumber;
    }

    public boolean isSameAs(ChargePointInfo other) {
        if (other == null) {
            return false;
        }
        return Objects.equals(this.chargePointVendor, other.chargePointVendor) && Objects.equals(this.chargePointModel, other.chargePointModel) && Objects.equals(this.chargePointSerialNumber, other.chargePointSerialNumber) && Objects.equals(this.chargeBoxSerialNumber, other.chargeBoxSerialNumber) && Objects.equals(this.firmwareVersion, other.firmwareVersion) && Objects.equals(this.iccid, other.iccid) && Objects.equals(this.imsi, other.imsi) && Objects.equals(this.meterType, other.meterType) && Objects.equals(this.meterSerialNumber, other.meterSerialNumber);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ChargePointInfo{");
        if (this.id != null) {
            builder.append("id=");
            builder.append(this.id);
            builder.append(", ");
        }
        if (this.chargePointVendor != null) {
            builder.append("chargePointVendor=");
            builder.append(this.chargePointVendor);
            builder.append(", ");
        }
        if (this.chargePointModel != null) {
            builder.append("chargePointModel=");
            builder.append(this.chargePointModel);
            builder.append(", ");
        }
        if (this.chargePointSerialNumber != null) {
            builder.append("chargePointSerialNumber=");
            builder.append(this.chargePointSerialNumber);
            builder.append(", ");
        }
        if (this.chargeBoxSerialNumber != null) {
            builder.append("chargeBoxSerialNumber=");
            builder.append(this.chargeBoxSerialNumber);
            builder.append(", ");
        }
        if (this.firmwareVersion != null) {
            builder.append("firmwareVersion=");
            builder.append(this.firmwareVersion);
            builder.append(", ");
        }
        if (this.iccid != null) {
            builder.append("iccid=");
            builder.append(this.iccid);
            builder.append(", ");
        }
        if (this.imsi != null) {
            builder.append("imsi=");
            builder.append(this.imsi);
            builder.append(", ");
        }
        if (this.meterType != null) {
            builder.append("meterType=");
            builder.append(this.meterType);
            builder.append(", ");
        }
        if (this.meterSerialNumber != null) {
            builder.append("meterSerialNumber=");
            builder.append(this.meterSerialNumber);
        }
        builder.append("}");
        return builder.toString();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getChargePointVendor() {
        return this.chargePointVendor;
    }

    public void setChargePointVendor(String chargePointVendor) {
        this.chargePointVendor = chargePointVendor;
    }

    public String getChargePointModel() {
        return this.chargePointModel;
    }

    public void setChargePointModel(String chargePointModel) {
        this.chargePointModel = chargePointModel;
    }

    public String getChargePointSerialNumber() {
        return this.chargePointSerialNumber;
    }

    public void setChargePointSerialNumber(String chargePointSerialNumber) {
        this.chargePointSerialNumber = chargePointSerialNumber;
    }

    public String getChargeBoxSerialNumber() {
        return this.chargeBoxSerialNumber;
    }

    public void setChargeBoxSerialNumber(String chargeBoxSerialNumber) {
        this.chargeBoxSerialNumber = chargeBoxSerialNumber;
    }

    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public void setFirmwareVersion(String firmwareVersion) {
        this.firmwareVersion = firmwareVersion;
    }

    public String getIccid() {
        return this.iccid;
    }

    public void setIccid(String iccid) {
        this.iccid = iccid;
    }

    public String getImsi() {
        return this.imsi;
    }

    public void setImsi(String imsi) {
        this.imsi = imsi;
    }

    public String getMeterType() {
        return this.meterType;
    }

    public void setMeterType(String meterType) {
        this.meterType = meterType;
    }

    public String getMeterSerialNumber() {
        return this.meterSerialNumber;
    }

    public void setMeterSerialNumber(String meterSerialNumber) {
        this.meterSerialNumber = meterSerialNumber;
    }
}

