/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.ocpp.domain;

import java.util.Objects;
import net.solarnetwork.ocpp.domain.ChargePointIdentity;
import net.solarnetwork.util.ObjectUtils;

public class ChargePointSessionIdentity
implements Comparable<ChargePointSessionIdentity> {
    private final ChargePointIdentity identity;
    private final String sessionId;

    public ChargePointSessionIdentity(ChargePointIdentity identity, String sessionId) {
        this.identity = (ChargePointIdentity)ObjectUtils.requireNonNullArgument((Object)identity, (String)"identity");
        this.sessionId = (String)ObjectUtils.requireNonNullArgument((Object)sessionId, (String)"sessionId");
    }

    public static ChargePointSessionIdentity boundaryKey(ChargePointIdentity identity) {
        return new ChargePointSessionIdentity(identity, "");
    }

    public int hashCode() {
        return Objects.hash(this.identity, this.sessionId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ChargePointSessionIdentity)) {
            return false;
        }
        ChargePointSessionIdentity other = (ChargePointSessionIdentity)obj;
        return Objects.equals(this.identity, other.identity) && Objects.equals(this.sessionId, other.sessionId);
    }

    @Override
    public int compareTo(ChargePointSessionIdentity o) {
        int result = this.identity.compareTo(o.identity);
        if (result == 0) {
            result = this.sessionId.compareTo(o.sessionId);
        }
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ChargePointSessionIdentity{identifier=");
        builder.append(this.identity.getIdentifier());
        builder.append(", userIdentifier=");
        builder.append(this.identity.getUserIdentifier());
        builder.append(", sessionId=");
        builder.append(this.sessionId);
        builder.append("}");
        return builder.toString();
    }

    public String getIdentifier() {
        return this.identity.getIdentifier();
    }

    public Object getUserIdentifier() {
        return this.identity.getUserIdentifier();
    }

    public final ChargePointIdentity getIdentity() {
        return this.identity;
    }

    public final String getSessionId() {
        return this.sessionId;
    }
}

