/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.ocpp.domain;

import net.solarnetwork.domain.CodedValue;

public enum ChargePointStatus implements CodedValue
{
    Unknown(0),
    Available(1),
    Occupied(2),
    Faulted(3),
    Unavailable(4),
    Reserved(5),
    Preparing(6),
    Charging(7),
    SuspendedEV(8),
    SuspendedEVSE(9),
    Finishing(10);

    private final byte code;

    private ChargePointStatus(int code) {
        this.code = (byte)code;
    }

    public int getCode() {
        return this.code & 0xFF;
    }

    public static ChargePointStatus forCode(int code) {
        byte c = (byte)code;
        for (ChargePointStatus v : ChargePointStatus.values()) {
            if (v.code != c) continue;
            return v;
        }
        return Unknown;
    }
}

