/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.ocpp.domain;

import java.time.Instant;
import java.util.UUID;
import net.solarnetwork.dao.BasicUuidEntity;
import net.solarnetwork.ocpp.domain.ChargeSessionEndReason;

public class ChargeSession
extends BasicUuidEntity {
    private static final long serialVersionUID = 1726642518109338069L;
    private final String authId;
    private final long chargePointId;
    private final int evseId;
    private final int connectorId;
    private final String transactionId;
    private Instant ended;
    private String endAuthId;
    private ChargeSessionEndReason endReason;
    private Instant posted;

    public ChargeSession(String authId, long chargePointId, int connectorId, String transactionId) {
        this(null, null, authId, chargePointId, 0, connectorId, transactionId);
    }

    public ChargeSession(String authId, long chargePointId, int evseId, int connectorId, String transactionId) {
        this(null, null, authId, chargePointId, evseId, connectorId, transactionId);
    }

    public ChargeSession(UUID id, Instant created, String authId, long chargePointId, int connectorId, String transactionId) {
        this(id, created, authId, chargePointId, 0, connectorId, transactionId);
    }

    public ChargeSession(UUID id, Instant created, String authId, long chargePointId, int evseId, int connectorId, String transactionId) {
        super(id, created);
        this.authId = authId;
        this.chargePointId = chargePointId;
        this.evseId = evseId;
        this.connectorId = connectorId;
        this.transactionId = transactionId;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ChargeSession{id=");
        builder.append(this.getId());
        builder.append(", chargePointId=");
        builder.append(this.chargePointId);
        builder.append(", evseId=");
        builder.append(this.evseId);
        builder.append(", connectorId=");
        builder.append(this.connectorId);
        if (this.transactionId != null) {
            builder.append(", transactionId=");
            builder.append(this.transactionId);
            builder.append(", ");
        }
        if (this.ended != null) {
            builder.append("ended=");
            builder.append(this.ended);
        }
        builder.append("}");
        return builder.toString();
    }

    public String getAuthId() {
        return this.authId;
    }

    public long getChargePointId() {
        return this.chargePointId;
    }

    public int getEvseId() {
        return this.evseId;
    }

    public int getConnectorId() {
        return this.connectorId;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public Instant getEnded() {
        return this.ended;
    }

    public void setEnded(Instant ended) {
        this.ended = ended;
    }

    public ChargeSessionEndReason getEndReason() {
        return this.endReason;
    }

    public void setEndReason(ChargeSessionEndReason endReason) {
        this.endReason = endReason;
    }

    public String getEndAuthId() {
        return this.endAuthId;
    }

    public void setEndAuthId(String endAuthId) {
        this.endAuthId = endAuthId;
    }

    public Instant getPosted() {
        return this.posted;
    }

    public void setPosted(Instant posted) {
        this.posted = posted;
    }
}

