/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.ocpp.domain;

import java.time.Instant;
import java.util.Collections;
import net.solarnetwork.ocpp.domain.ChargePointIdentity;
import net.solarnetwork.ocpp.domain.ChargeSessionEndReason;
import net.solarnetwork.ocpp.domain.SampledValue;

public class ChargeSessionEndInfo {
    private final ChargePointIdentity chargePointId;
    private final String authorizationId;
    private final String transactionId;
    private final Instant timestampEnd;
    private final long meterEnd;
    private final ChargeSessionEndReason reason;
    private final Iterable<SampledValue> transactionData;

    private ChargeSessionEndInfo(Builder builder) {
        this.chargePointId = builder.chargePointId;
        this.authorizationId = builder.authorizationId;
        this.transactionId = builder.transactionId;
        this.timestampEnd = builder.timestampEnd;
        this.meterEnd = builder.meterEnd;
        this.reason = builder.reason;
        this.transactionData = builder.transactionData;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ChargeSessionEndInfo{");
        if (this.chargePointId != null) {
            builder.append("chargePointId=");
            builder.append(this.chargePointId);
            builder.append(", ");
        }
        if (this.authorizationId != null) {
            builder.append("authorizationId=");
            builder.append(this.authorizationId);
            builder.append(", ");
        }
        if (this.transactionId != null) {
            builder.append("transactionId=");
            builder.append(this.transactionId);
            builder.append(", ");
        }
        if (this.timestampEnd != null) {
            builder.append("timestampEnd=");
            builder.append(this.timestampEnd);
            builder.append(", ");
        }
        builder.append("meterEnd=");
        builder.append(this.meterEnd);
        builder.append(", ");
        if (this.reason != null) {
            builder.append("reason=");
            builder.append((Object)this.reason);
            builder.append(", ");
        }
        if (this.transactionData != null) {
            builder.append("transactionData=");
            builder.append(this.transactionData);
        }
        builder.append("}");
        return builder.toString();
    }

    public ChargePointIdentity getChargePointId() {
        return this.chargePointId;
    }

    public String getAuthorizationId() {
        return this.authorizationId;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public Instant getTimestampEnd() {
        return this.timestampEnd;
    }

    public long getMeterEnd() {
        return this.meterEnd;
    }

    public ChargeSessionEndReason getReason() {
        return this.reason;
    }

    public Iterable<SampledValue> getTransactionData() {
        return this.transactionData;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static final class Builder {
        private ChargePointIdentity chargePointId;
        private String authorizationId;
        private String transactionId;
        private Instant timestampEnd;
        private long meterEnd;
        private ChargeSessionEndReason reason;
        private Iterable<SampledValue> transactionData = Collections.emptyList();

        private Builder() {
        }

        private Builder(ChargeSessionEndInfo chargeSessionEndInfo) {
            this.chargePointId = chargeSessionEndInfo.chargePointId;
            this.authorizationId = chargeSessionEndInfo.authorizationId;
            this.transactionId = chargeSessionEndInfo.transactionId;
            this.timestampEnd = chargeSessionEndInfo.timestampEnd;
            this.meterEnd = chargeSessionEndInfo.meterEnd;
            this.reason = chargeSessionEndInfo.reason;
            this.transactionData = chargeSessionEndInfo.transactionData;
        }

        public Builder withChargePointId(ChargePointIdentity chargePointId) {
            this.chargePointId = chargePointId;
            return this;
        }

        public Builder withAuthorizationId(String authorizationId) {
            this.authorizationId = authorizationId;
            return this;
        }

        public Builder withTransactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public Builder withTimestampEnd(Instant timestampEnd) {
            this.timestampEnd = timestampEnd;
            return this;
        }

        public Builder withMeterEnd(long meterEnd) {
            this.meterEnd = meterEnd;
            return this;
        }

        public Builder withReason(ChargeSessionEndReason reason) {
            this.reason = reason;
            return this;
        }

        public Builder withTransactionData(Iterable<SampledValue> transactionData) {
            this.transactionData = transactionData;
            return this;
        }

        public ChargeSessionEndInfo build() {
            return new ChargeSessionEndInfo(this);
        }
    }
}

