/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.ocpp.domain;

import java.time.Instant;
import net.solarnetwork.ocpp.domain.ChargePointIdentity;

public class ChargeSessionStartInfo {
    private final ChargePointIdentity chargePointId;
    private final String authorizationId;
    private final String transactionId;
    private final int evseId;
    private final int connectorId;
    private final Instant timestampStart;
    private final long meterStart;
    private final Integer reservationId;

    private ChargeSessionStartInfo(Builder builder) {
        this.chargePointId = builder.chargePointId;
        this.authorizationId = builder.authorizationId;
        this.transactionId = builder.transactionId;
        this.evseId = builder.evseId;
        this.connectorId = builder.connectorId;
        this.timestampStart = builder.timestampStart;
        this.meterStart = builder.meterStart;
        this.reservationId = builder.reservationId;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ChargeSessionStartInfo{");
        if (this.chargePointId != null) {
            builder.append("chargePointId=");
            builder.append(this.chargePointId);
            builder.append(", ");
        }
        if (this.authorizationId != null) {
            builder.append("authorizationId=");
            builder.append(this.authorizationId);
            builder.append(", ");
        }
        if (this.transactionId != null) {
            builder.append("transactionId=");
            builder.append(this.transactionId);
            builder.append(", ");
        }
        builder.append("evseId=");
        builder.append(this.evseId);
        builder.append(", connectorId=");
        builder.append(this.connectorId);
        builder.append(", ");
        if (this.timestampStart != null) {
            builder.append("timestampStart=");
            builder.append(this.timestampStart);
            builder.append(", ");
        }
        builder.append("meterStart=");
        builder.append(this.meterStart);
        builder.append(", ");
        if (this.reservationId != null) {
            builder.append("reservationId=");
            builder.append(this.reservationId);
        }
        builder.append("}");
        return builder.toString();
    }

    public ChargePointIdentity getChargePointId() {
        return this.chargePointId;
    }

    public String getAuthorizationId() {
        return this.authorizationId;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public int getEvseId() {
        return this.evseId;
    }

    public int getConnectorId() {
        return this.connectorId;
    }

    public Instant getTimestampStart() {
        return this.timestampStart;
    }

    public long getMeterStart() {
        return this.meterStart;
    }

    public Integer getReservationId() {
        return this.reservationId;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ChargePointIdentity chargePointId;
        private String authorizationId;
        private String transactionId;
        private int evseId;
        private int connectorId;
        private Instant timestampStart;
        private long meterStart;
        private Integer reservationId;

        private Builder() {
        }

        private Builder(ChargeSessionStartInfo chargeSessionInfo) {
            this.chargePointId = chargeSessionInfo.chargePointId;
            this.authorizationId = chargeSessionInfo.authorizationId;
            this.transactionId = chargeSessionInfo.transactionId;
            this.evseId = chargeSessionInfo.evseId;
            this.connectorId = chargeSessionInfo.connectorId;
            this.timestampStart = chargeSessionInfo.timestampStart;
            this.meterStart = chargeSessionInfo.meterStart;
            this.reservationId = chargeSessionInfo.reservationId;
        }

        public Builder withChargePointId(ChargePointIdentity chargePointId) {
            this.chargePointId = chargePointId;
            return this;
        }

        public Builder withAuthorizationId(String authorizationId) {
            this.authorizationId = authorizationId;
            return this;
        }

        public Builder withTransactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public Builder withEvseId(int evseId) {
            this.evseId = evseId;
            return this;
        }

        public Builder withConnectorId(int connectorId) {
            this.connectorId = connectorId;
            return this;
        }

        public Builder withTimestampStart(Instant timestampStart) {
            this.timestampStart = timestampStart;
            return this;
        }

        public Builder withMeterStart(long meterStart) {
            this.meterStart = meterStart;
            return this;
        }

        public Builder withReservationId(Integer reservationId) {
            this.reservationId = reservationId;
            return this;
        }

        public ChargeSessionStartInfo build() {
            return new ChargeSessionStartInfo(this);
        }
    }
}

