/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.ocpp.domain;

import java.time.Instant;
import java.util.UUID;
import net.solarnetwork.dao.BasicUuidEntity;
import net.solarnetwork.domain.Differentiable;
import net.solarnetwork.ocpp.domain.ChargingProfileInfo;
import net.solarnetwork.ocpp.domain.ChargingProfileKind;
import net.solarnetwork.ocpp.domain.ChargingProfilePurpose;
import net.solarnetwork.ocpp.domain.ChargingScheduleInfo;
import net.solarnetwork.ocpp.domain.UnitOfMeasure;

public class ChargingProfile
extends BasicUuidEntity
implements Differentiable<ChargingProfile> {
    private static final long serialVersionUID = -5952532162434074127L;
    public static final ChargingProfilePurpose DEFAULT_PURPOSE = ChargingProfilePurpose.ChargePointMaxProfile;
    public static final ChargingProfileKind DEFAULT_KIND = ChargingProfileKind.Recurring;
    public static final UnitOfMeasure DEFAULT_RATE_UNIT = UnitOfMeasure.W;
    private ChargingProfileInfo info;

    public ChargingProfile() {
        this.info = new ChargingProfileInfo(DEFAULT_PURPOSE, DEFAULT_KIND, new ChargingScheduleInfo(DEFAULT_RATE_UNIT));
    }

    public ChargingProfile(UUID id) {
        this(id, Instant.now());
    }

    public ChargingProfile(UUID id, Instant created) {
        this(id, created, new ChargingProfileInfo(DEFAULT_PURPOSE, DEFAULT_KIND, new ChargingScheduleInfo(DEFAULT_RATE_UNIT)));
    }

    public ChargingProfile(UUID id, Instant created, ChargingProfileInfo info) {
        super(id, created);
        this.setInfo(info);
    }

    public ChargingProfile(ChargingProfile other) {
        this((UUID)other.getId(), other.getCreated());
        this.info = new ChargingProfileInfo(other.info);
    }

    public boolean isSameAs(ChargingProfile other) {
        if (other == null) {
            return false;
        }
        return this.info.isSameAs(other.info);
    }

    public boolean differsFrom(ChargingProfile other) {
        return !this.isSameAs(other);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ChargingProfile{");
        if (this.getId() != null) {
            builder.append("id=");
            builder.append(this.getId());
        }
        if (this.info != null) {
            builder.append("info=");
            builder.append(this.info);
            builder.append(", ");
        }
        builder.append("}");
        return builder.toString();
    }

    public ChargingProfileInfo getInfo() {
        return this.info;
    }

    public void setInfo(ChargingProfileInfo info) {
        if (info == null) {
            throw new IllegalArgumentException("The info parameter must not be null.");
        }
        this.info = info;
    }
}

