/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.ocpp.domain;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Objects;
import net.solarnetwork.domain.Differentiable;
import net.solarnetwork.ocpp.domain.ChargingProfileKind;
import net.solarnetwork.ocpp.domain.ChargingProfilePurpose;
import net.solarnetwork.ocpp.domain.ChargingScheduleInfo;
import net.solarnetwork.ocpp.domain.ChargingScheduleRecurrency;
import net.solarnetwork.util.DateUtils;

public class ChargingProfileInfo
implements Differentiable<ChargingProfileInfo> {
    private ChargingProfilePurpose purpose;
    private ChargingProfileKind kind;
    private ChargingScheduleRecurrency recurrency;
    private Instant validFrom;
    private Instant validTo;
    private ChargingScheduleInfo schedule;

    public ChargingProfileInfo(ChargingProfilePurpose purpose, ChargingProfileKind kind, ChargingScheduleInfo schedule) {
        this.setPurpose(purpose);
        this.setKind(kind);
        this.setSchedule(schedule);
    }

    public ChargingProfileInfo(ChargingProfilePurpose purpose, ChargingProfileKind kind, ChargingScheduleRecurrency recurrency, Instant validFrom, Instant validTo, ChargingScheduleInfo schedule) {
        this(purpose, kind, schedule);
        this.recurrency = recurrency;
        this.validFrom = validFrom;
        this.validTo = validTo;
    }

    public ChargingProfileInfo(ChargingProfileInfo other) {
        this(other.purpose, other.kind, other.recurrency, other.validFrom, other.validTo, new ChargingScheduleInfo(other.schedule));
    }

    public boolean isSameAs(ChargingProfileInfo other) {
        if (other == null) {
            return false;
        }
        return Objects.equals((Object)this.purpose, (Object)other.purpose) && Objects.equals((Object)this.kind, (Object)other.kind) && Objects.equals((Object)this.recurrency, (Object)other.recurrency) && Objects.equals(this.validFrom, other.validFrom) && Objects.equals(this.validTo, other.validTo) && this.schedule.isSameAs(other.schedule);
    }

    public boolean differsFrom(ChargingProfileInfo other) {
        return !this.isSameAs(other);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ChargingProfileInfo{");
        if (this.purpose != null) {
            builder.append("purpose=");
            builder.append((Object)this.purpose);
            builder.append(", ");
        }
        if (this.kind != null) {
            builder.append("kind=");
            builder.append((Object)this.kind);
            builder.append(", ");
        }
        if (this.recurrency != null) {
            builder.append("recurrency=");
            builder.append((Object)this.recurrency);
            builder.append(", ");
        }
        if (this.validFrom != null) {
            builder.append("validFrom=");
            builder.append(this.validFrom);
            builder.append(", ");
        }
        if (this.validTo != null) {
            builder.append("validTo=");
            builder.append(this.validTo);
            builder.append(", ");
        }
        if (this.schedule != null) {
            builder.append("schedule=");
            builder.append(this.schedule);
        }
        builder.append("}");
        return builder.toString();
    }

    public ChargingProfilePurpose getPurpose() {
        return this.purpose;
    }

    public void setPurpose(ChargingProfilePurpose purpose) {
        if (purpose == null) {
            throw new IllegalArgumentException("The purpose parameter must not be null.");
        }
        this.purpose = purpose;
    }

    public int getPurposeCode() {
        return this.getPurpose().getCode();
    }

    public void setPurposeCode(int code) {
        this.setPurpose(ChargingProfilePurpose.forCode(code));
    }

    public ChargingProfileKind getKind() {
        return this.kind;
    }

    public void setKind(ChargingProfileKind kind) {
        if (kind == null) {
            throw new IllegalArgumentException("The kind parameter must not be null.");
        }
        this.kind = kind;
    }

    public int getKindCode() {
        return this.getKind().getCode();
    }

    public void setKindCode(int code) {
        this.setKind(ChargingProfileKind.forCode(code));
    }

    public ChargingScheduleRecurrency getRecurrency() {
        return this.recurrency;
    }

    public void setRecurrency(ChargingScheduleRecurrency recurrency) {
        this.recurrency = recurrency;
    }

    public int getRecurrencyCode() {
        ChargingScheduleRecurrency r = this.getRecurrency();
        if (r == null) {
            r = ChargingScheduleRecurrency.Unknown;
        }
        return r.getCode();
    }

    public void setRecurrencyCode(int code) {
        this.setRecurrency(ChargingScheduleRecurrency.forCode(code));
    }

    public Instant getValidFrom() {
        return this.validFrom;
    }

    public void setValidFrom(Instant validFrom) {
        this.validFrom = validFrom;
    }

    public String getValidFromValue() {
        Instant ts = this.getValidFrom();
        return ts != null ? DateUtils.ISO_DATE_OPT_TIME_ALT_LOCAL.format(ts) : null;
    }

    public void setValidFromValue(String value) {
        ZonedDateTime date;
        Instant ts = null;
        if (value != null && (date = DateUtils.parseIsoAltTimestamp((String)value, (ZoneId)ZoneId.systemDefault())) != null) {
            ts = date.toInstant();
        }
        this.setValidFrom(ts);
    }

    public Instant getValidTo() {
        return this.validTo;
    }

    public void setValidTo(Instant validTo) {
        this.validTo = validTo;
    }

    public String getValidToValue() {
        Instant ts = this.getValidTo();
        return ts != null ? DateUtils.ISO_DATE_OPT_TIME_ALT_LOCAL.format(ts) : null;
    }

    public void setValidToValue(String value) {
        ZonedDateTime date;
        Instant ts = null;
        if (value != null && (date = DateUtils.parseIsoAltTimestamp((String)value, (ZoneId)ZoneId.systemDefault())) != null) {
            ts = date.toInstant();
        }
        this.setValidTo(ts);
    }

    public ChargingScheduleInfo getSchedule() {
        return this.schedule;
    }

    public void setSchedule(ChargingScheduleInfo schedule) {
        if (schedule == null) {
            throw new IllegalArgumentException("The schedule parameter must not be null.");
        }
        this.schedule = schedule;
    }
}

