/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.ocpp.domain;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.solarnetwork.domain.Differentiable;
import net.solarnetwork.ocpp.domain.ChargingSchedulePeriodInfo;
import net.solarnetwork.ocpp.domain.UnitOfMeasure;
import net.solarnetwork.util.DateUtils;

public class ChargingScheduleInfo
implements Differentiable<ChargingScheduleInfo> {
    private Duration duration;
    private Instant start;
    private UnitOfMeasure rateUnit;
    private BigDecimal minRate;
    private List<ChargingSchedulePeriodInfo> periods;

    public ChargingScheduleInfo(UnitOfMeasure rateUnit) {
        this.setRateUnit(rateUnit);
    }

    public ChargingScheduleInfo(Duration duration, Instant start, UnitOfMeasure rateUnit, BigDecimal minRate) {
        this(rateUnit);
        this.duration = duration;
        this.start = start;
        this.minRate = minRate;
    }

    public ChargingScheduleInfo(ChargingScheduleInfo other) {
        this(other.duration, other.start, other.rateUnit, other.minRate);
        if (other.periods != null) {
            this.setPeriods(new ArrayList<ChargingSchedulePeriodInfo>(other.periods));
        }
    }

    public boolean isSameAs(ChargingScheduleInfo other) {
        if (other == null) {
            return false;
        }
        return Objects.equals(this.duration, other.duration) && Objects.equals(this.start, other.start) && Objects.equals((Object)this.rateUnit, (Object)other.rateUnit) && Objects.equals(this.minRate, other.minRate) && Objects.equals(this.periods, other.periods);
    }

    public boolean differsFrom(ChargingScheduleInfo other) {
        return !this.isSameAs(other);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ChargingScheduleInfo{");
        if (this.duration != null) {
            builder.append("duration=");
            builder.append(this.duration);
            builder.append(", ");
        }
        if (this.start != null) {
            builder.append("start=");
            builder.append(this.start);
            builder.append(", ");
        }
        if (this.rateUnit != null) {
            builder.append("rateUnit=");
            builder.append((Object)this.rateUnit);
            builder.append(", ");
        }
        if (this.minRate != null) {
            builder.append("minRate=");
            builder.append(this.minRate);
            builder.append(", ");
        }
        if (this.periods != null) {
            builder.append("periods=");
            builder.append(this.periods);
        }
        builder.append("}");
        return builder.toString();
    }

    public Duration getDuration() {
        return this.duration;
    }

    public void setDuration(Duration duration) {
        this.duration = duration;
    }

    public int getDurationSeconds() {
        Duration d = this.getDuration();
        return d != null ? (int)d.getSeconds() : 0;
    }

    public void setDurationSeconds(int seconds) {
        this.setDuration(seconds > 0 ? Duration.ofSeconds(seconds) : null);
    }

    public Instant getStart() {
        return this.start;
    }

    public void setStart(Instant start) {
        this.start = start;
    }

    public String getStartValue() {
        Instant ts = this.getStart();
        return ts != null ? DateUtils.ISO_DATE_OPT_TIME_ALT_LOCAL.format(ts) : null;
    }

    public void setStartValue(String value) {
        ZonedDateTime date;
        Instant ts = null;
        if (value != null && (date = DateUtils.parseIsoAltTimestamp((String)value, (ZoneId)ZoneId.systemDefault())) != null) {
            ts = date.toInstant();
        }
        this.setStart(ts);
    }

    public UnitOfMeasure getRateUnit() {
        return this.rateUnit;
    }

    public void setRateUnit(UnitOfMeasure rateUnit) {
        if (rateUnit == null) {
            throw new IllegalArgumentException("The rateUnit parameter must not be null.");
        }
        this.rateUnit = rateUnit;
    }

    public int getRateUnitCode() {
        return this.getRateUnit().getCode();
    }

    public void setRateUnitCode(int code) {
        this.setRateUnit(UnitOfMeasure.forCode(code));
    }

    public BigDecimal getMinRate() {
        return this.minRate;
    }

    public void setMinRate(BigDecimal minRate) {
        if (minRate != null && minRate.scale() != 1) {
            minRate = minRate.setScale(1, RoundingMode.HALF_UP);
        }
        this.minRate = minRate;
    }

    public void addPeriod(ChargingSchedulePeriodInfo period) {
        List<ChargingSchedulePeriodInfo> list = this.getPeriods();
        if (list == null) {
            list = new ArrayList<ChargingSchedulePeriodInfo>(4);
            this.setPeriods(list);
        }
        list.add(period);
    }

    public List<ChargingSchedulePeriodInfo> getPeriods() {
        return this.periods;
    }

    public void setPeriods(List<ChargingSchedulePeriodInfo> periods) {
        this.periods = periods;
    }

    public synchronized int getPeriodsCount() {
        List<ChargingSchedulePeriodInfo> periods = this.getPeriods();
        return periods != null ? periods.size() : 0;
    }

    public void setPeriodsCount(int count) {
        int currCount;
        List<ChargingSchedulePeriodInfo> infos = this.getPeriods();
        int n = currCount = infos != null ? infos.size() : 0;
        if (currCount == count) {
            return;
        }
        while (currCount < count) {
            if (infos == null) {
                infos = new ArrayList<ChargingSchedulePeriodInfo>(count);
                this.setPeriods(infos);
            }
            infos.add(new ChargingSchedulePeriodInfo());
            ++currCount;
        }
        while (currCount > count) {
            infos.remove(--currCount);
        }
    }
}

