/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.ocpp.domain;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.util.Objects;
import net.solarnetwork.domain.Differentiable;

public class ChargingSchedulePeriodInfo
implements Differentiable<ChargingSchedulePeriodInfo> {
    private Duration startOffset;
    private BigDecimal rateLimit;
    private Integer numPhases;

    public ChargingSchedulePeriodInfo() {
        this(Duration.ZERO, BigDecimal.ZERO);
    }

    public ChargingSchedulePeriodInfo(Duration startOffset, BigDecimal rateLimit) {
        this.setStartOffset(startOffset);
        this.setRateLimit(rateLimit);
    }

    public ChargingSchedulePeriodInfo(Duration startOffset, BigDecimal rateLimit, Integer numPhases) {
        this(startOffset, rateLimit);
        this.numPhases = numPhases;
    }

    public ChargingSchedulePeriodInfo(ChargingSchedulePeriodInfo other) {
        this(other.startOffset, other.rateLimit, other.numPhases);
    }

    public boolean isSameAs(ChargingSchedulePeriodInfo other) {
        if (other == null) {
            return false;
        }
        return Objects.equals(this.startOffset, other.startOffset) && Objects.equals(this.rateLimit, other.rateLimit) && Objects.equals(this.numPhases, other.numPhases);
    }

    public boolean differsFrom(ChargingSchedulePeriodInfo other) {
        return !this.isSameAs(other);
    }

    public int hashCode() {
        return Objects.hash(this.numPhases, this.rateLimit, this.startOffset);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ChargingSchedulePeriodInfo)) {
            return false;
        }
        ChargingSchedulePeriodInfo other = (ChargingSchedulePeriodInfo)obj;
        return Objects.equals(this.numPhases, other.numPhases) && Objects.equals(this.rateLimit, other.rateLimit) && Objects.equals(this.startOffset, other.startOffset);
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        builder2.append("ChargingSchedulePeriodInfo{");
        if (this.startOffset != null) {
            builder2.append("startOffset=");
            builder2.append(this.startOffset);
            builder2.append(", ");
        }
        if (this.rateLimit != null) {
            builder2.append("rateLimit=");
            builder2.append(this.rateLimit);
            builder2.append(", ");
        }
        if (this.numPhases != null) {
            builder2.append("numPhases=");
            builder2.append(this.numPhases);
        }
        builder2.append("}");
        return builder2.toString();
    }

    public Duration getStartOffset() {
        return this.startOffset;
    }

    public void setStartOffset(Duration startOffset) {
        this.startOffset = startOffset;
    }

    public int getStartOffsetSeconds() {
        return (int)this.getStartOffset().getSeconds();
    }

    public void setStartOffsetSeconds(int seconds) {
        this.setStartOffset(Duration.ofSeconds(seconds));
    }

    public BigDecimal getRateLimit() {
        return this.rateLimit;
    }

    public void setRateLimit(BigDecimal rateLimit) {
        if (rateLimit == null) {
            throw new IllegalArgumentException("The rateLimit parameter must not be null.");
        }
        if (rateLimit.scale() != 1) {
            rateLimit = rateLimit.setScale(1, RoundingMode.HALF_UP);
        }
        this.rateLimit = rateLimit;
    }

    public Integer getNumPhases() {
        return this.numPhases;
    }

    public void setNumPhases(Integer numPhases) {
        this.numPhases = numPhases;
    }
}

