/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.ocpp.domain;

import net.solarnetwork.domain.CodedValue;

public enum Location implements CodedValue
{
    Body(1),
    Cable(2),
    EV(3),
    Inlet(4),
    Outlet(0);

    private final byte code;

    private Location(int code) {
        this.code = (byte)code;
    }

    public int getCode() {
        return this.code & 0xFF;
    }

    public static Location forCode(int code) {
        switch (code) {
            case 1: {
                return Body;
            }
            case 2: {
                return Cable;
            }
            case 3: {
                return EV;
            }
            case 4: {
                return Inlet;
            }
        }
        return Outlet;
    }
}

