/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.ocpp.domain;

import net.solarnetwork.domain.CodedValue;

public enum Measurand implements CodedValue
{
    Unknown(0),
    CurrentExport(1),
    CurrentImport(2),
    CurrentOffered(17),
    EnergyActiveExportInterval(3),
    EnergyActiveExportRegister(4),
    EnergyActiveImportInterval(5),
    EnergyActiveImportRegister(6),
    EnergyReactiveExportInterval(7),
    EnergyReactiveExportRegister(8),
    EnergyReactiveImportInterval(9),
    EnergyReactiveImportRegister(10),
    Frequency(18),
    PowerActiveExport(11),
    PowerActiveImport(12),
    PowerFactor(19),
    PowerOffered(20),
    PowerReactiveExport(13),
    PowerReactiveImport(14),
    RPM(21),
    SoC(22),
    Temperature(15),
    Voltage(16);

    private final byte code;

    private Measurand(int code) {
        this.code = (byte)code;
    }

    public int getCode() {
        return this.code & 0xFF;
    }

    public static Measurand forCode(int code) {
        byte c = (byte)code;
        for (Measurand v : Measurand.values()) {
            if (v.code != c) continue;
            return v;
        }
        return Unknown;
    }
}

