/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.ocpp.domain;

import java.util.concurrent.atomic.AtomicBoolean;
import net.solarnetwork.ocpp.domain.ActionMessage;
import net.solarnetwork.ocpp.service.ActionMessageResultHandler;

public class PendingActionMessage {
    private final long date;
    private final boolean outbound;
    private final ActionMessage<Object> message;
    private final ActionMessageResultHandler<Object, Object> handler;
    private final AtomicBoolean processed;

    public PendingActionMessage(ActionMessage<Object> message, ActionMessageResultHandler<Object, Object> handler) {
        if (message == null) {
            throw new IllegalArgumentException("The message parameter must not be null.");
        }
        if (handler == null) {
            throw new IllegalArgumentException("The handler parameter must not be null.");
        }
        this.date = System.currentTimeMillis();
        this.outbound = true;
        this.message = message;
        this.handler = handler;
        this.processed = new AtomicBoolean(false);
    }

    public PendingActionMessage(ActionMessage<Object> message) {
        this.date = System.currentTimeMillis();
        this.outbound = false;
        if (message == null) {
            throw new IllegalArgumentException("The message parameter must not be null.");
        }
        this.message = message;
        this.handler = null;
        this.processed = new AtomicBoolean(false);
    }

    public long getDate() {
        return this.date;
    }

    public boolean isOutbound() {
        return this.outbound;
    }

    public ActionMessage<Object> getMessage() {
        return this.message;
    }

    public ActionMessageResultHandler<Object, Object> getHandler() {
        return this.handler;
    }

    public boolean doProcess() {
        return this.processed.compareAndSet(false, true);
    }
}

