/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.ocpp.domain;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.Instant;
import java.util.Objects;
import java.util.UUID;
import net.solarnetwork.ocpp.domain.Location;
import net.solarnetwork.ocpp.domain.Measurand;
import net.solarnetwork.ocpp.domain.Phase;
import net.solarnetwork.ocpp.domain.ReadingContext;
import net.solarnetwork.ocpp.domain.UnitOfMeasure;

@JsonDeserialize(builder=Builder.class)
public class SampledValue
implements Comparable<SampledValue> {
    private final UUID sessionId;
    private final Instant timestamp;
    private final String value;
    private final ReadingContext context;
    private final Measurand measurand;
    private final Phase phase;
    private final Location location;
    private final UnitOfMeasure unit;

    public SampledValue(UUID sessionId, Instant timestamp, String value, ReadingContext context, Measurand measurand, Phase phase, Location location, UnitOfMeasure unit) {
        this.sessionId = sessionId;
        this.timestamp = timestamp;
        this.value = value;
        this.context = context;
        this.measurand = measurand;
        this.phase = phase;
        this.location = location;
        this.unit = unit;
    }

    private SampledValue(Builder builder) {
        this(builder.sessionId, builder.timestamp, builder.value, builder.context, builder.measurand, builder.phase, builder.location, builder.unit);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.context, this.location, this.measurand, this.phase, this.sessionId, this.timestamp});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SampledValue)) {
            return false;
        }
        SampledValue other = (SampledValue)obj;
        return this.context == other.context && this.location == other.location && this.measurand == other.measurand && this.phase == other.phase && Objects.equals(this.sessionId, other.sessionId) && Objects.equals(this.timestamp, other.timestamp);
    }

    @Override
    public int compareTo(SampledValue o) {
        int result = this.timestamp.compareTo(o.timestamp);
        if (result != 0) {
            return result;
        }
        if (this.context != o.context) {
            if (this.context == null) {
                return -1;
            }
            if (o.context == null) {
                return 1;
            }
            result = Integer.compare(this.context.getCode(), o.context.getCode());
            if (result != 0) {
                return result;
            }
        }
        if (this.location != o.location) {
            if (this.location == null) {
                return -1;
            }
            if (o.location == null) {
                return 1;
            }
            result = Integer.compare(this.location.getCode(), o.location.getCode());
            if (result != 0) {
                return result;
            }
        }
        if (this.measurand != o.measurand) {
            if (this.measurand == null) {
                return -1;
            }
            if (o.measurand == null) {
                return 1;
            }
            result = Integer.compare(this.measurand.getCode(), o.measurand.getCode());
            if (result != 0) {
                return result;
            }
        }
        if (this.phase == o.phase) {
            return 0;
        }
        if (this.phase == null) {
            return -1;
        }
        if (o.phase == null) {
            return 1;
        }
        return Integer.compare(this.phase.getCode(), o.phase.getCode());
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        builder2.append("SampledValue{");
        if (this.timestamp != null) {
            builder2.append("timestamp=");
            builder2.append(this.timestamp);
            builder2.append(", ");
        }
        if (this.context != null) {
            builder2.append("context=");
            builder2.append((Object)this.context);
            builder2.append(", ");
        }
        if (this.location != null) {
            builder2.append("location=");
            builder2.append((Object)this.location);
            builder2.append(", ");
        }
        if (this.measurand != null) {
            builder2.append("measurand=");
            builder2.append((Object)this.measurand);
            builder2.append(", ");
        }
        if (this.value != null) {
            builder2.append("value=");
            builder2.append(this.value);
        }
        builder2.append("}");
        return builder2.toString();
    }

    public UUID getSessionId() {
        return this.sessionId;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public String getValue() {
        return this.value;
    }

    public ReadingContext getContext() {
        return this.context;
    }

    public Measurand getMeasurand() {
        return this.measurand;
    }

    public Phase getPhase() {
        return this.phase;
    }

    public Location getLocation() {
        return this.location;
    }

    public UnitOfMeasure getUnit() {
        return this.unit;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static final class Builder {
        private UUID sessionId;
        private Instant timestamp;
        private String value;
        private ReadingContext context;
        private Measurand measurand;
        private Phase phase;
        private Location location;
        private UnitOfMeasure unit;

        private Builder() {
        }

        private Builder(SampledValue value) {
            this.sessionId = value.sessionId;
            this.timestamp = value.timestamp;
            this.value = value.value;
            this.context = value.context;
            this.measurand = value.measurand;
            this.phase = value.phase;
            this.location = value.location;
            this.unit = value.unit;
        }

        public Builder withSessionId(UUID sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public Builder withTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder withValue(String value) {
            this.value = value;
            return this;
        }

        public Builder withContext(ReadingContext context) {
            this.context = context;
            return this;
        }

        public Builder withMeasurand(Measurand measurand) {
            this.measurand = measurand;
            return this;
        }

        public Builder withPhase(Phase phase) {
            this.phase = phase;
            return this;
        }

        public Builder withLocation(Location location) {
            this.location = location;
            return this;
        }

        public Builder withUnit(UnitOfMeasure unit) {
            this.unit = unit;
            return this;
        }

        public SampledValue build() {
            return new SampledValue(this);
        }
    }
}

