/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.ocpp.domain;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.Instant;
import java.util.Objects;
import net.solarnetwork.ocpp.domain.ChargePointErrorCode;
import net.solarnetwork.ocpp.domain.ChargePointStatus;

@JsonDeserialize(builder=Builder.class)
@JsonPropertyOrder(value={"evseId", "connectorId", "timestamp", "status", "errorCode", "info", "vendorId", "vendorErrorCode"})
public class StatusNotification {
    private final int evseId;
    private final int connectorId;
    private final ChargePointStatus status;
    private final ChargePointErrorCode errorCode;
    private final String info;
    private final Instant timestamp;
    private final String vendorId;
    private final String vendorErrorCode;

    public StatusNotification(int connectorId, ChargePointStatus status, ChargePointErrorCode errorCode, String info, Instant timestamp, String vendorId, String vendorErrorCode) {
        this(0, connectorId, status, errorCode, info, timestamp, vendorId, vendorErrorCode);
    }

    public StatusNotification(int evseId, int connectorId, ChargePointStatus status, ChargePointErrorCode errorCode, String info, Instant timestamp, String vendorId, String vendorErrorCode) {
        this.evseId = evseId;
        this.connectorId = connectorId;
        this.status = status;
        this.errorCode = errorCode;
        this.info = info;
        this.timestamp = timestamp;
        this.vendorId = vendorId;
        this.vendorErrorCode = vendorErrorCode;
    }

    private StatusNotification(Builder builder) {
        this(builder.evseId, builder.connectorId, builder.status, builder.errorCode, builder.info, builder.timestamp, builder.vendorId, builder.vendorErrorCode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.evseId, this.connectorId, this.errorCode, this.info, this.status, this.timestamp, this.vendorErrorCode, this.vendorId});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StatusNotification)) {
            return false;
        }
        StatusNotification other = (StatusNotification)obj;
        return this.connectorId == other.connectorId && this.isSameAs(other);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("StatusNotification{evseId=");
        builder.append(this.evseId);
        builder.append(", connectorId=");
        builder.append(this.connectorId);
        builder.append(", ");
        if (this.status != null) {
            builder.append("status=");
            builder.append((Object)this.status);
            builder.append(", ");
        }
        if (this.errorCode != null) {
            builder.append("errorCode=");
            builder.append((Object)this.errorCode);
            builder.append(", ");
        }
        if (this.timestamp != null) {
            builder.append("timestamp=");
            builder.append(this.timestamp);
            builder.append(", ");
        }
        if (this.info != null) {
            builder.append("info=");
            builder.append(this.info);
            builder.append(", ");
        }
        if (this.vendorId != null) {
            builder.append("vendorId=");
            builder.append(this.vendorId);
            builder.append(", ");
        }
        if (this.vendorErrorCode != null) {
            builder.append("vendorErrorCode=");
            builder.append(this.vendorErrorCode);
        }
        builder.append("}");
        return builder.toString();
    }

    public int getEvseId() {
        return this.evseId;
    }

    public int getConnectorId() {
        return this.connectorId;
    }

    public ChargePointStatus getStatus() {
        return this.status;
    }

    public ChargePointErrorCode getErrorCode() {
        return this.errorCode;
    }

    public String getInfo() {
        return this.info;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public String getVendorId() {
        return this.vendorId;
    }

    public String getVendorErrorCode() {
        return this.vendorErrorCode;
    }

    public boolean isSameAs(StatusNotification other) {
        if (other == null) {
            return false;
        }
        return Objects.equals((Object)this.status, (Object)other.status) && Objects.equals((Object)this.errorCode, (Object)other.errorCode) && Objects.equals(this.info, other.info) && Objects.equals(this.timestamp, other.timestamp) && Objects.equals(this.vendorId, other.vendorId) && Objects.equals(this.vendorErrorCode, other.vendorErrorCode);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static final class Builder {
        private int evseId;
        private int connectorId;
        private ChargePointStatus status;
        private ChargePointErrorCode errorCode;
        private String info;
        private Instant timestamp;
        private String vendorId;
        private String vendorErrorCode;

        private Builder() {
        }

        private Builder(StatusNotification statusNotification) {
            this.evseId = statusNotification.evseId;
            this.connectorId = statusNotification.connectorId;
            this.status = statusNotification.status;
            this.errorCode = statusNotification.errorCode;
            this.info = statusNotification.info;
            this.timestamp = statusNotification.timestamp;
            this.vendorId = statusNotification.vendorId;
            this.vendorErrorCode = statusNotification.vendorErrorCode;
        }

        public Builder withEvseId(int evseId) {
            this.evseId = evseId;
            return this;
        }

        public Builder withConnectorId(int connectorId) {
            this.connectorId = connectorId;
            return this;
        }

        public Builder withStatus(ChargePointStatus status) {
            this.status = status;
            return this;
        }

        public Builder withErrorCode(ChargePointErrorCode errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public Builder withInfo(String info) {
            this.info = info;
            return this;
        }

        public Builder withTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder withVendorId(String vendorId) {
            this.vendorId = vendorId;
            return this;
        }

        public Builder withVendorErrorCode(String vendorErrorCode) {
            this.vendorErrorCode = vendorErrorCode;
            return this;
        }

        public StatusNotification build() {
            return new StatusNotification(this);
        }
    }
}

