/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.ocpp.domain;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.Instant;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import net.solarnetwork.dao.BasicLongEntity;
import net.solarnetwork.domain.Differentiable;
import net.solarnetwork.ocpp.domain.ChargePointAuthorizationDetails;
import net.solarnetwork.ocpp.domain.ChargePointIdentity;
import net.solarnetwork.util.StringUtils;

public class SystemUser
extends BasicLongEntity
implements Differentiable<SystemUser>,
ChargePointAuthorizationDetails {
    private static final long serialVersionUID = -8412183373239562934L;
    private String username;
    private String password;
    private Set<String> allowedChargePoints;

    public SystemUser() {
    }

    public SystemUser(Long id, Instant created) {
        super(id, created);
    }

    public SystemUser(Instant created, String username, String password) {
        super(null, created);
        this.setUsername(username);
        this.setPassword(password);
    }

    public SystemUser(SystemUser other) {
        super((Long)other.getId(), other.getCreated());
        this.setUsername(other.getUsername());
        this.setPassword(other.getPassword());
        Set<String> allowed = other.getAllowedChargePoints();
        if (allowed != null) {
            this.setAllowedChargePoints(new LinkedHashSet<String>(allowed));
        }
    }

    public ChargePointIdentity chargePointIdentity(String identifier) {
        return new ChargePointIdentity(identifier, "");
    }

    public boolean isSameAs(SystemUser other) {
        if (other == null) {
            return false;
        }
        int myCpSize = this.allowedChargePoints != null ? this.allowedChargePoints.size() : 0;
        int oCpSize = other.allowedChargePoints != null ? other.allowedChargePoints.size() : 0;
        return Objects.equals(this.username, other.username) && Objects.equals(this.password, other.password) && (myCpSize == 0 && oCpSize == 0 || Objects.equals(this.allowedChargePoints, other.allowedChargePoints));
    }

    public boolean differsFrom(SystemUser other) {
        return !this.isSameAs(other);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SystemUser{");
        if (this.username != null) {
            builder.append("username=");
            builder.append(this.username);
            builder.append(", ");
        }
        if (this.allowedChargePoints != null) {
            builder.append("allowedChargePoints=");
            builder.append(this.allowedChargePoints);
        }
        builder.append("}");
        return builder.toString();
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Set<String> getAllowedChargePoints() {
        return this.allowedChargePoints;
    }

    @JsonDeserialize(as=LinkedHashSet.class)
    public void setAllowedChargePoints(Set<String> allowedChargePoints) {
        this.allowedChargePoints = allowedChargePoints;
    }

    public String getAllowedChargePointsValue() {
        return StringUtils.commaDelimitedStringFromCollection(this.getAllowedChargePoints());
    }

    public void setAllowedChargePointsValue(String list) {
        this.setAllowedChargePoints(StringUtils.commaDelimitedStringToSet((String)list));
    }

    public String[] getAllowedChargePointsArray() {
        Set<String> allowed = this.getAllowedChargePoints();
        return allowed != null ? allowed.toArray(new String[allowed.size()]) : null;
    }

    public void setAllowedChargePointsArray(String[] array) {
        this.setAllowedChargePoints((Set<String>)(array != null ? new LinkedHashSet<String>(Arrays.asList(array)) : null));
    }
}

