/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.ocpp.domain;

import net.solarnetwork.domain.CodedValue;

public enum UnitOfMeasure implements CodedValue
{
    Unknown(0),
    Wh(1),
    kWh(2),
    varh(3),
    kvarh(4),
    W(5),
    kW(6),
    var(7),
    kvar(8),
    Amp(9),
    Volt(10),
    Celsius(11),
    A(12),
    Fahrenheit(13),
    VA(14),
    kVA(15),
    V(16),
    K(17),
    Percent(18),
    ASU(19),
    B(20),
    dB(21),
    dBm(22),
    Deg(23),
    Hz(24),
    lx(25),
    m(26),
    ms2(27),
    N(28),
    Ohm(29),
    kPa(30),
    RH(31),
    RPM(32),
    s(33),
    kVAh(34);

    private final byte code;

    private UnitOfMeasure(int code) {
        this.code = (byte)code;
    }

    public int getCode() {
        return this.code & 0xFF;
    }

    public static UnitOfMeasure forCode(int code) {
        byte c = (byte)code;
        for (UnitOfMeasure v : UnitOfMeasure.values()) {
            if (v.code != c) continue;
            return v;
        }
        return Unknown;
    }
}

