/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.ocpp.service;

import java.util.Set;
import net.solarnetwork.ocpp.domain.Action;
import net.solarnetwork.ocpp.domain.ActionMessage;
import net.solarnetwork.ocpp.service.ActionMessageProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseActionMessageProcessor<T, R>
implements ActionMessageProcessor<T, R> {
    private final Class<T> messageType;
    private final Class<R> resultType;
    private final Set<Action> supportedActions;
    private final boolean emptyMessageAllowed;
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    public BaseActionMessageProcessor(Class<T> messageType, Class<R> resultType, Set<Action> supportedActions) {
        this(messageType, resultType, supportedActions, false);
    }

    public BaseActionMessageProcessor(Class<T> messageType, Class<R> resultType, Set<Action> supportedActions, boolean emptyMessageAllowed) {
        this.messageType = messageType;
        this.resultType = resultType;
        if (supportedActions == null) {
            throw new IllegalArgumentException("The supportedActions parameter must not be null.");
        }
        this.supportedActions = supportedActions;
        this.emptyMessageAllowed = emptyMessageAllowed;
    }

    @Override
    public Set<Action> getSupportedActions() {
        return this.supportedActions;
    }

    @Override
    public boolean isMessageSupported(ActionMessage<?> message) {
        return message != null && message.getAction() != null && this.supportedActions.contains(message.getAction()) && ((this.messageType == null || this.emptyMessageAllowed) && message.getMessage() == null || this.messageType != null && message.getMessage() != null && this.messageType.isAssignableFrom(message.getMessage().getClass()));
    }

    public Class<T> getMessageType() {
        return this.messageType;
    }

    public Class<R> getResultType() {
        return this.resultType;
    }
}

