/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.ocpp.service;

import java.util.Set;
import java.util.TreeSet;
import net.solarnetwork.ocpp.domain.ChargePointIdentity;
import net.solarnetwork.ocpp.service.ChargePointBroker;
import net.solarnetwork.ocpp.service.ChargePointRouter;
import net.solarnetwork.service.OptionalServiceCollection;

public class ChargePointBrokerTracker
implements ChargePointRouter {
    private final OptionalServiceCollection<ChargePointBroker> brokers;

    public ChargePointBrokerTracker(OptionalServiceCollection<ChargePointBroker> brokers) {
        if (brokers == null) {
            throw new IllegalArgumentException("The brokers parameter must not be null.");
        }
        this.brokers = brokers;
    }

    @Override
    public Set<ChargePointIdentity> availableChargePointsIds() {
        TreeSet<ChargePointIdentity> ids = new TreeSet<ChargePointIdentity>();
        for (ChargePointBroker b : this.brokers.services()) {
            ids.addAll(b.availableChargePointsIds());
        }
        return ids;
    }

    @Override
    public boolean isChargePointAvailable(ChargePointIdentity identity) {
        if (identity != null) {
            for (ChargePointBroker b : this.brokers.services()) {
                if (!b.isChargePointAvailable(identity)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public ChargePointBroker brokerForChargePoint(ChargePointIdentity identity) {
        if (identity != null) {
            for (ChargePointBroker b : this.brokers.services()) {
                if (!b.isChargePointAvailable(identity)) continue;
                return b;
            }
        }
        return null;
    }
}

