/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.ocpp.service;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.solarnetwork.ocpp.domain.ChargePointIdentity;
import net.solarnetwork.ocpp.domain.PendingActionMessage;
import net.solarnetwork.ocpp.service.ActionMessageQueue;

public class SimpleActionMessageQueue
implements ActionMessageQueue {
    private final Map<ChargePointIdentity, Deque<PendingActionMessage>> pendingMessages;

    public SimpleActionMessageQueue() {
        this(new ConcurrentHashMap<ChargePointIdentity, Deque<PendingActionMessage>>(8, 0.7f, 2));
    }

    public SimpleActionMessageQueue(Map<ChargePointIdentity, Deque<PendingActionMessage>> pendingMessages) {
        this.pendingMessages = pendingMessages;
    }

    @Override
    public Deque<PendingActionMessage> pendingMessageQueue(ChargePointIdentity clientId) {
        return this.pendingMessages.computeIfAbsent(clientId, k -> new ArrayDeque(8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPendingMessage(PendingActionMessage msg, Consumer<Deque<PendingActionMessage>> fn) {
        Deque<PendingActionMessage> q;
        ChargePointIdentity clientId = msg.getMessage().getClientId();
        Deque<PendingActionMessage> deque = q = this.pendingMessageQueue(clientId);
        synchronized (deque) {
            q.add(msg);
            if (fn != null && q.peek() == msg) {
                fn.accept(q);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PendingActionMessage pollPendingMessage(ChargePointIdentity clientId) {
        PendingActionMessage msg = null;
        Deque<PendingActionMessage> q = this.pendingMessages.get(clientId);
        if (q != null) {
            Deque<PendingActionMessage> deque = q;
            synchronized (deque) {
                msg = q.pollFirst();
            }
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PendingActionMessage pollPendingMessage(ChargePointIdentity clientId, String messageId) {
        PendingActionMessage msg = null;
        Deque<PendingActionMessage> q = this.pendingMessages.get(clientId);
        if (q != null) {
            Deque<PendingActionMessage> deque = q;
            synchronized (deque) {
                Iterator<PendingActionMessage> itr = q.descendingIterator();
                while (itr.hasNext()) {
                    PendingActionMessage oneMsg = itr.next();
                    if (!oneMsg.getMessage().getMessageId().equals(messageId)) continue;
                    msg = oneMsg;
                    itr.remove();
                    break;
                }
            }
        }
        return msg;
    }

    @Override
    public Iterable<Map.Entry<ChargePointIdentity, Deque<PendingActionMessage>>> allQueues() {
        return this.pendingMessages.entrySet();
    }
}

