/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.ocpp.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Map;
import net.solarnetwork.ocpp.domain.Action;
import net.solarnetwork.ocpp.domain.SchemaValidationException;
import net.solarnetwork.ocpp.json.ActionPayloadDecoder;

public final class OcppInstructionUtils {
    public static final String OCPP_V16_TOPIC = "OCPP_v16";
    public static final String OCPP_ACTION_PARAM = "action";
    public static final String OCPP_CHARGER_IDENTIFIER_PARAM = "chargerIdentifier";
    public static final String OCPP_CHARGE_POINT_ID_PARAM = "chargePointId";
    public static final String OCPP_MESSAGE_PARAM = "msg";

    private OcppInstructionUtils() {
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> T decodeJsonOcppInstructionMessage(ObjectMapper objectMapper, Action action, Map<String, String> params, ActionPayloadDecoder chargePointActionPayloadDecoder, JsonOcppInstructionMessageHandler<T> handler) {
        if (handler == null) {
            throw new IllegalArgumentException("The handler argument must be provided.");
        }
        try {
            void var6_10;
            ObjectNode jsonPayload;
            if (params.containsKey(OCPP_MESSAGE_PARAM)) {
                JsonNode jsonNode = objectMapper.readTree(params.get(OCPP_MESSAGE_PARAM));
                if (jsonNode.isNull()) {
                    jsonPayload = null;
                } else {
                    if (!(jsonNode instanceof ObjectNode)) throw new IOException("OCPP msg parameter must be a JSON object.");
                    jsonPayload = (ObjectNode)jsonNode;
                }
            } else {
                jsonPayload = (ObjectNode)objectMapper.valueToTree(params);
            }
            if (chargePointActionPayloadDecoder != null) {
                Object t = chargePointActionPayloadDecoder.decodeActionPayload(action, false, (JsonNode)jsonPayload);
                return handler.handleMessage(null, jsonPayload, var6_10);
            } else {
                Map<String, String> map = params;
            }
            return handler.handleMessage(null, jsonPayload, var6_10);
        }
        catch (IOException | SchemaValidationException e) {
            return handler.handleMessage(e, null, null);
        }
    }

    @FunctionalInterface
    public static interface JsonOcppInstructionMessageHandler<T> {
        public T handleMessage(Exception var1, ObjectNode var2, Object var3);
    }
}

