/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.pki.bc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.security.auth.x500.X500Principal;
import net.solarnetwork.service.CertificateException;
import net.solarnetwork.service.CertificateService;
import net.solarnetwork.service.CertificationAuthorityService;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX500NameUtil;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.OperatorException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.PKCS10CertificationRequestBuilder;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemReader;
import org.bouncycastle.util.io.pem.PemWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BCCertificateService
implements CertificateService,
CertificationAuthorityService {
    private final AtomicLong counter = new AtomicLong(System.currentTimeMillis());
    private int certificateExpireDays = 730;
    private int authorityExpireDays = 7300;
    private String signatureAlgorithm = "SHA256WithRSA";
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public X509Certificate generateCertificate(String dn, PublicKey publicKey, PrivateKey privateKey) {
        ContentSigner signer;
        X500Principal issuer = new X500Principal(dn);
        Date now = new Date();
        Date expire = new Date(now.getTime() + 86400000L * (long)this.certificateExpireDays);
        JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(issuer, new BigInteger(String.valueOf(this.counter.incrementAndGet())), now, expire, issuer, publicKey);
        JcaContentSignerBuilder signerBuilder = new JcaContentSignerBuilder(this.signatureAlgorithm);
        try {
            signer = signerBuilder.build(privateKey);
        }
        catch (OperatorCreationException e) {
            throw new CertificateException("Error signing certificate", (Throwable)e);
        }
        X509CertificateHolder holder = builder.build(signer);
        JcaX509CertificateConverter converter = new JcaX509CertificateConverter();
        try {
            return converter.getCertificate(holder);
        }
        catch (java.security.cert.CertificateException e) {
            throw new CertificateException("Error creating certificate", (Throwable)e);
        }
    }

    public X509Certificate generateCertificationAuthorityCertificate(String dn, PublicKey publicKey, PrivateKey privateKey) {
        ContentSigner signer;
        X500Principal issuer = new X500Principal(dn);
        Date now = new Date();
        Date expire = new Date(now.getTime() + 86400000L * (long)this.authorityExpireDays);
        JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(issuer, new BigInteger("0"), now, expire, issuer, publicKey);
        JcaContentSignerBuilder signerBuilder = new JcaContentSignerBuilder(this.signatureAlgorithm);
        DefaultDigestAlgorithmIdentifierFinder digestAlgFinder = new DefaultDigestAlgorithmIdentifierFinder();
        try {
            DigestCalculatorProvider digestCalcProvider = new JcaDigestCalculatorProviderBuilder().setProvider((Provider)new BouncyCastleProvider()).build();
            JcaX509ExtensionUtils extUtils = new JcaX509ExtensionUtils(digestCalcProvider.get(digestAlgFinder.find("SHA-256")));
            builder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(true));
            builder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)extUtils.createSubjectKeyIdentifier(publicKey));
            builder.addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(198));
            builder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)extUtils.createAuthorityKeyIdentifier(publicKey));
            signer = signerBuilder.build(privateKey);
        }
        catch (OperatorCreationException e) {
            this.log.error("Error generating CA certificate [{}]", (Object)dn, (Object)e);
            throw new CertificateException("Error signing CA certificate", (Throwable)e);
        }
        catch (CertIOException e) {
            this.log.error("Error generating CA certificate [{}]", (Object)dn, (Object)e);
            throw new CertificateException("Error signing CA certificate", (Throwable)e);
        }
        X509CertificateHolder holder = builder.build(signer);
        JcaX509CertificateConverter converter = new JcaX509CertificateConverter();
        try {
            return converter.getCertificate(holder);
        }
        catch (java.security.cert.CertificateException e) {
            throw new CertificateException("Error creating certificate", (Throwable)e);
        }
    }

    public X509Certificate signCertificate(String csrPEM, X509Certificate caCert, PrivateKey privateKey) throws CertificateException {
        if (!((String)csrPEM).matches("(?is)^\\s*-----BEGIN.*")) {
            csrPEM = "-----BEGIN CERTIFICATE REQUEST-----\n" + (String)csrPEM + "\n-----END CERTIFICATE REQUEST-----\n";
        }
        PemReader reader = null;
        try {
            ContentSigner signer;
            SubjectPublicKeyInfo subjectPublicKeyInfo;
            X500Name subject;
            reader = new PemReader((Reader)new StringReader((String)csrPEM));
            PemObject pemObj = reader.readPemObject();
            this.log.debug("Parsed PEM type {}", (Object)pemObj.getType());
            if (pemObj.getType().equalsIgnoreCase("certificate")) {
                X509Certificate[] chain = this.parsePKCS7CertificateChainString((String)csrPEM);
                subject = JcaX500NameUtil.getSubject((X509Certificate)chain[0]);
                subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)chain[0].getPublicKey().getEncoded());
            } else {
                PKCS10CertificationRequest csr = new PKCS10CertificationRequest(pemObj.getContent());
                subject = csr.getSubject();
                subjectPublicKeyInfo = csr.getSubjectPublicKeyInfo();
            }
            Date now = new Date();
            Date expire = new Date(now.getTime() + 86400000L * (long)this.certificateExpireDays);
            X509v3CertificateBuilder builder = new X509v3CertificateBuilder(JcaX500NameUtil.getIssuer((X509Certificate)caCert), new BigInteger(String.valueOf(this.counter.incrementAndGet())), now, expire, subject, subjectPublicKeyInfo);
            JcaContentSignerBuilder signerBuilder = new JcaContentSignerBuilder(this.signatureAlgorithm);
            DefaultDigestAlgorithmIdentifierFinder digestAlgFinder = new DefaultDigestAlgorithmIdentifierFinder();
            try {
                DigestCalculatorProvider digestCalcProvider = new JcaDigestCalculatorProviderBuilder().setProvider((Provider)new BouncyCastleProvider()).build();
                JcaX509ExtensionUtils extUtils = new JcaX509ExtensionUtils(digestCalcProvider.get(digestAlgFinder.find("SHA-256")));
                builder.addExtension(Extension.basicConstraints, false, (ASN1Encodable)new BasicConstraints(false));
                builder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)extUtils.createSubjectKeyIdentifier(subjectPublicKeyInfo));
                builder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)extUtils.createAuthorityKeyIdentifier(caCert));
                signer = signerBuilder.build(privateKey);
            }
            catch (OperatorException e) {
                this.log.error("Error signing CSR {}", (Object)subject, (Object)e);
                throw new CertificateException("Error signing CSR" + String.valueOf(subject) + ": " + e.getMessage());
            }
            catch (CertificateEncodingException e) {
                this.log.error("Error signing CSR {}", (Object)subject.toString(), (Object)e);
                throw new CertificateException("Error signing CSR" + String.valueOf(subject) + ": " + e.getMessage());
            }
            X509CertificateHolder holder = builder.build(signer);
            JcaX509CertificateConverter converter = new JcaX509CertificateConverter();
            try {
                X509Certificate x509Certificate = converter.getCertificate(holder);
                return x509Certificate;
            }
            catch (java.security.cert.CertificateException e) {
                try {
                    throw new CertificateException("Error creating certificate", (Throwable)e);
                }
                catch (IOException e2) {
                    throw new CertificateException("Error signing CSR", (Throwable)e2);
                }
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e2) {
                    this.log.warn("IOException closing PemReader", (Throwable)e2);
                }
            }
        }
    }

    public String generatePKCS10CertificateRequestString(X509Certificate cert, PrivateKey privateKey) throws CertificateException {
        ContentSigner signer;
        JcaX509CertificateHolder holder;
        try {
            holder = new JcaX509CertificateHolder(cert);
        }
        catch (CertificateEncodingException e) {
            throw new CertificateException("Error creating CSR", (Throwable)e);
        }
        PKCS10CertificationRequestBuilder builder = new PKCS10CertificationRequestBuilder(holder.getSubject(), holder.getSubjectPublicKeyInfo());
        JcaContentSignerBuilder signerBuilder = new JcaContentSignerBuilder(this.signatureAlgorithm);
        try {
            signer = signerBuilder.build(privateKey);
        }
        catch (OperatorCreationException e) {
            throw new CertificateException("Error signing certificate request", (Throwable)e);
        }
        PKCS10CertificationRequest csr = builder.build(signer);
        StringWriter writer = new StringWriter();
        PemWriter pemWriter = new PemWriter((Writer)writer);
        try {
            pemWriter.writeObject((PemObjectGenerator)new PemObject("CERTIFICATE REQUEST", csr.getEncoded()));
        }
        catch (IOException e) {
            throw new CertificateException("Error signing certificate", (Throwable)e);
        }
        finally {
            try {
                pemWriter.flush();
                pemWriter.close();
                writer.close();
            }
            catch (IOException iOException) {}
        }
        return writer.toString();
    }

    private void orderCertificateChain(Map<X500Principal, X509Certificate> map, List<X509Certificate> results, X509Certificate c) {
        X509Certificate parent = map.get(c.getIssuerX500Principal());
        if (parent != null) {
            this.orderCertificateChain(map, results, parent);
        }
        ListIterator<X509Certificate> itr = results.listIterator();
        while (itr.hasNext()) {
            X509Certificate p = itr.next();
            if (!p.getSubjectX500Principal().equals(c.getIssuerX500Principal())) continue;
            itr.previous();
            itr.add(c);
            break;
        }
        map.remove(c.getSubjectX500Principal());
    }

    private void orderCertificateChain(Map<X500Principal, X509Certificate> map, List<X509Certificate> results) {
        while (map.size() > 0) {
            this.orderCertificateChain(map, results, map.values().iterator().next());
        }
    }

    public X509Certificate[] parsePKCS7CertificateChainString(String pem) throws CertificateException {
        if (!((String)pem).matches("(?is)^\\s*-----BEGIN.*")) {
            pem = "-----BEGIN CERTIFICATE CHAIN-----\n" + (String)pem + "\n-----END CERTIFICATE CHAIN-----\n";
        }
        PemReader reader = new PemReader((Reader)new StringReader((String)pem));
        ArrayList<X509Certificate> results = new ArrayList<X509Certificate>(3);
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            PemObject pemObj = reader.readPemObject();
            this.log.debug("Parsed PEM type {}", (Object)pemObj.getType());
            Collection<? extends Certificate> certs = cf.generateCertificates(new ByteArrayInputStream(pemObj.getContent()));
            LinkedHashMap<X500Principal, X509Certificate> map = new LinkedHashMap<X500Principal, X509Certificate>();
            for (Certificate certificate : certs) {
                X509Certificate x509 = (X509Certificate)certificate;
                if (x509.getIssuerX500Principal().equals(x509.getSubjectX500Principal())) {
                    results.add(x509);
                    continue;
                }
                map.put(x509.getSubjectX500Principal(), x509);
            }
            if (results.size() == 0) {
                results.addAll(map.values());
            } else {
                this.orderCertificateChain(map, results);
            }
        }
        catch (IOException e) {
            throw new CertificateException("Error reading certificate", (Throwable)e);
        }
        catch (java.security.cert.CertificateException e) {
            throw new CertificateException("Error loading CertificateFactory", (Throwable)e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        return results.toArray(new X509Certificate[results.size()]);
    }

    public String generatePKCS7CertificateChainString(X509Certificate[] chain) throws CertificateException {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            List<X509Certificate> chainList = Arrays.asList(chain);
            CertPath path = cf.generateCertPath(chainList);
            StringWriter out = new StringWriter();
            PemWriter writer = new PemWriter((Writer)out);
            PemObject pemObj = new PemObject("CERTIFICATE" + (chain.length > 1 ? " CHAIN" : ""), path.getEncoded("PKCS7"));
            writer.writeObject((PemObjectGenerator)pemObj);
            writer.flush();
            writer.close();
            out.close();
            String result = out.toString();
            this.log.debug("Generated cert chain:\n{}", (Object)result);
            return result;
        }
        catch (IOException e) {
            throw new CertificateException("Error generating PKCS#7 chain", (Throwable)e);
        }
        catch (java.security.cert.CertificateException e) {
            throw new CertificateException("Error generating PKCS#7 chain", (Throwable)e);
        }
    }

    public void setCertificateExpireDays(int certificateExpireDays) {
        this.certificateExpireDays = certificateExpireDays;
    }

    public void setSignatureAlgorithm(String signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public void setAuthorityExpireDays(int authorityExpireDays) {
        this.authorityExpireDays = authorityExpireDays;
    }
}

