/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.pki.bc;

import java.io.UnsupportedEncodingException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.solarnetwork.service.PasswordEncoder;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.params.KeyParameter;

public class BCPBKDF2PasswordEncoder
implements PasswordEncoder {
    public static final int DEFAULT_SALT_LENGTH = 8;
    public static final int DEFAULT_KEY_LENGTH = 32;
    public static final int DEFAULT_ITERATIONS = 131072;
    private static final Pattern ENCODING_PATTERN = Pattern.compile("(\\A[0-9a-fA-F]+)\\$(\\d+)\\$([0-9a-fA-F]+)");
    private int saltLength = 8;
    private int keyLength = 32;
    private int iterations = 131072;
    private final SecureRandom random = new SecureRandom();

    public String encode(CharSequence rawPassword) {
        int itr = this.iterations;
        int keySize = this.keyLength * 8;
        byte[] salt = new byte[this.saltLength];
        this.random.nextBytes(salt);
        try {
            byte[] dk = BCPBKDF2PasswordEncoder.derivePBKDF2SHA256Key(rawPassword.toString().getBytes("UTF-8"), salt, keySize, itr);
            StringBuilder buf = new StringBuilder();
            buf.append(Hex.encodeHexString((byte[])salt));
            buf.append('$');
            buf.append(itr);
            buf.append('$');
            buf.append(Hex.encodeHexString((byte[])dk));
            return buf.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Error encoding raw password as UTF-8", e);
        }
    }

    public boolean isPasswordEncrypted(CharSequence password) {
        return password != null && password.length() > 0 && ENCODING_PATTERN.matcher(password).matches();
    }

    public boolean matches(CharSequence rawPassword, String encodedPassword) {
        if (encodedPassword == null || encodedPassword.length() == 0) {
            return false;
        }
        Matcher matcher = ENCODING_PATTERN.matcher(encodedPassword);
        if (!matcher.matches()) {
            return false;
        }
        try {
            byte[] salt = Hex.decodeHex((char[])matcher.group(1).toCharArray());
            int itr = Integer.parseInt(matcher.group(2));
            byte[] digest = Hex.decodeHex((char[])matcher.group(3).toCharArray());
            int keySize = digest.length * 8;
            byte[] computed = BCPBKDF2PasswordEncoder.derivePBKDF2SHA256Key(rawPassword.toString().getBytes("UTF-8"), salt, keySize, itr);
            return Arrays.equals(computed, digest);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Error decoding password as UTF-8", e);
        }
        catch (DecoderException e) {
            throw new RuntimeException("Error decoding password as hex", e);
        }
    }

    public static final byte[] derivePBKDF2SHA256Key(byte[] rawPassword, byte[] salt, int keySize, int iterations) {
        PKCS5S2ParametersGenerator gen = new PKCS5S2ParametersGenerator((Digest)new SHA256Digest());
        gen.init(rawPassword, salt, iterations);
        byte[] dk = ((KeyParameter)gen.generateDerivedParameters(keySize)).getKey();
        return dk;
    }

    public static final void main(String[] arguments) {
        if (arguments.length < 1) {
            System.err.println("Usage: " + BCPBKDF2PasswordEncoder.class.getName() + " <password>");
            System.exit(1);
        }
        BCPBKDF2PasswordEncoder encoder = new BCPBKDF2PasswordEncoder();
        System.out.println(arguments[0] + " = " + encoder.encode(arguments[0]));
    }

    public void setSaltLength(int saltLength) {
        this.saltLength = saltLength;
    }

    public void setKeyLength(int keyLength) {
        this.keyLength = keyLength;
    }

    public void setIterations(int iterations) {
        this.iterations = iterations;
    }
}

