/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.common.s3.sdk2;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import net.solarnetwork.common.s3.S3Client;
import net.solarnetwork.common.s3.S3Object;
import net.solarnetwork.common.s3.S3ObjectMetadata;
import net.solarnetwork.common.s3.S3ObjectRef;
import net.solarnetwork.common.s3.S3ObjectReference;
import net.solarnetwork.common.s3.sdk2.Sdk2S3Object;
import net.solarnetwork.common.s3.sdk2.Sdk2TransferListenerAdapter;
import net.solarnetwork.service.ProgressListener;
import net.solarnetwork.service.RemoteServiceException;
import net.solarnetwork.settings.SettingSpecifier;
import net.solarnetwork.settings.SettingsChangeObserver;
import net.solarnetwork.settings.support.BaseSettingsSpecifierLocalizedServiceInfoProvider;
import net.solarnetwork.settings.support.BasicTextFieldSettingSpecifier;
import net.solarnetwork.util.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProviderChain;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.http.nio.netty.NettySdkAsyncHttpService;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClientBuilder;
import software.amazon.awssdk.services.s3.model.Delete;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.GetUrlRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;
import software.amazon.awssdk.transfer.s3.S3TransferManager;
import software.amazon.awssdk.transfer.s3.model.Download;
import software.amazon.awssdk.transfer.s3.model.DownloadRequest;
import software.amazon.awssdk.transfer.s3.model.Upload;
import software.amazon.awssdk.transfer.s3.model.UploadRequest;

public class Sdk2S3Client
extends BaseSettingsSpecifierLocalizedServiceInfoProvider
implements S3Client,
SettingsChangeObserver {
    public static final String DEFAULT_REGION_NAME = Region.US_WEST_2.id();
    public static final int DEFAULT_MAXIMUM_KEYS_PER_REQUEST = 500;
    public static final String CONTENT_DISPOSITION_KEY = "Content-Disposition";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final ExecutorService executorService;
    private String accessToken;
    private String accessSecret;
    private String bucketName;
    private String regionName = DEFAULT_REGION_NAME;
    private int maximumKeysPerRequest = 500;
    private AwsCredentialsProvider credentialsProvider;
    private AwsCredentialsProvider tokenCredentialsProvider;
    private S3AsyncClient s3Client;
    private S3TransferManager s3TransferManager;

    public Sdk2S3Client(ExecutorService executorService) {
        this(executorService, Sdk2S3Client.class.getName());
    }

    public Sdk2S3Client(ExecutorService executorService, String id) {
        super(id);
        this.executorService = (ExecutorService)ObjectUtils.requireNonNullArgument((Object)executorService, (String)"executorService");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void configurationChanged(Map<String, Object> properties) {
        if (this.accessToken != null && this.accessSecret != null) {
            this.tokenCredentialsProvider = StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)this.accessToken, (String)this.accessSecret));
        }
        if (this.s3TransferManager != null) {
            try {
                this.s3TransferManager.close();
            }
            catch (Exception e) {
                this.log.warn("Error closing S3TransferManager for {}/{} token {}", new Object[]{this.regionName, this.bucketName, this.accessToken, e});
            }
            finally {
                this.s3TransferManager = null;
            }
        }
        if (this.s3Client != null) {
            try {
                this.s3Client.close();
            }
            catch (Exception e) {
                this.log.warn("Error closing S3Client for {}/{} token {}", new Object[]{this.regionName, this.bucketName, this.accessToken, e});
            }
            finally {
                this.s3Client = null;
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("S3Client{region=");
        builder.append(this.regionName);
        builder.append(",bucket=");
        builder.append(this.bucketName);
        builder.append("}");
        return builder.toString();
    }

    public boolean isConfigured() {
        return this.bucketName != null && this.bucketName.length() > 0 && this.regionName != null && this.regionName.length() > 0 && (this.credentialsProvider != null || this.tokenCredentialsProvider != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T performAction(String description, BiFunction<S3AsyncClient, S3TransferManager, CompletableFuture<T>> action) throws IOException {
        S3TransferManager mgr;
        S3AsyncClient client;
        Sdk2S3Client sdk2S3Client = this;
        synchronized (sdk2S3Client) {
            client = this.getClient();
            mgr = this.s3TransferManager;
        }
        try {
            return action.apply(client, mgr).get();
        }
        catch (InterruptedException | CancellationException | ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SdkClientException) {
                SdkClientException ex = (SdkClientException)cause;
                this.log.debug("Error communicating with AWS: {}", (Object)ex.getMessage());
                throw new IOException("Error communicating with AWS", e);
            }
            if (cause instanceof AwsServiceException) {
                AwsServiceException ex = (AwsServiceException)cause;
                this.log.warn("AWS error: {}; HTTP code {}; AWS code {}; service {}", new Object[]{ex.getMessage(), ex.statusCode(), ex.awsErrorDetails().errorCode(), ex.awsErrorDetails().serviceName()});
            } else if (e instanceof CancellationException || e instanceof InterruptedException) {
                this.log.debug("AWS action was cancelled.");
            }
            throw new RemoteServiceException("Error " + description, (Throwable)e);
        }
    }

    public Set<S3ObjectReference> listObjects(String prefix) throws IOException {
        LinkedHashSet result = new LinkedHashSet(100);
        return (Set)this.performAction("listing S3 objects at " + prefix, (client, xfer) -> {
            ListObjectsV2Response listResult;
            ListObjectsV2Request.Builder req = ListObjectsV2Request.builder().bucket(this.bucketName).maxKeys(Integer.valueOf(this.maximumKeysPerRequest)).prefix(prefix);
            CompletableFuture<Set> f = new CompletableFuture<Set>();
            do {
                try {
                    listResult = (ListObjectsV2Response)client.listObjectsV2((ListObjectsV2Request)req.build()).get();
                }
                catch (Exception e) {
                    Throwable cause = e.getCause();
                    f.completeExceptionally(cause);
                    return f;
                }
                for (software.amazon.awssdk.services.s3.model.S3Object obj : listResult.contents()) {
                    GetUrlRequest getReq = (GetUrlRequest)GetUrlRequest.builder().bucket(this.bucketName).key(obj.key()).build();
                    URL url = client.utilities().getUrl(getReq);
                    result.add(new S3ObjectRef(obj.key(), obj.size().longValue(), Date.from(obj.lastModified()), url));
                }
                req.continuationToken(listResult.nextContinuationToken());
            } while (listResult.isTruncated().booleanValue());
            if (this.log.isDebugEnabled()) {
                this.log.debug("Listed {} S3 objects: {}", (Object)result.size(), result.stream().map(r -> r.getKey()).collect(Collectors.toList()));
            }
            f.complete(result);
            return f;
        });
    }

    public String getObjectAsString(String key) throws IOException {
        return (String)this.performAction("getting S3 object at " + key, (client, xfer) -> client.getObject(r -> r.bucket(this.bucketName).key(key), AsyncResponseTransformer.toBytes()).thenApplyAsync(res -> {
            String result = res.asUtf8String();
            this.log.debug("Got S3 string {}/{} ({})", new Object[]{this.bucketName, key, result.length()});
            return result;
        }));
    }

    public URL getObjectURL(String key) {
        try {
            return (URL)this.performAction("get object URL", (client, xfer) -> CompletableFuture.completedFuture(client.utilities().getUrl(r -> r.bucket(this.bucketName).key(key))));
        }
        catch (IOException e) {
            throw new RemoteServiceException("Error composing object URL for key " + key, (Throwable)e);
        }
    }

    public <P> S3Object getObject(String key, ProgressListener<P> progressListener, P progressContext) throws IOException {
        return (S3Object)this.performAction("getting S3 object at " + key, (client, xfer) -> {
            URL url = client.utilities().getUrl(r -> r.bucket(this.bucketName).key(key));
            DownloadRequest.TypedBuilder builder = DownloadRequest.builder().getObjectRequest(r -> r.bucket(this.bucketName).key(key)).responseTransformer(AsyncResponseTransformer.toBlockingInputStream());
            if (progressListener != null) {
                builder = builder.addTransferListener(new Sdk2TransferListenerAdapter<Object>(progressListener, progressContext));
            }
            DownloadRequest downloadRequest = (DownloadRequest)builder.build();
            Download download = xfer.download(downloadRequest);
            return download.completionFuture().thenApplyAsync(result -> {
                this.log.debug("Got S3 object {}/{}", (Object)this.bucketName, (Object)key);
                return new Sdk2S3Object((ResponseInputStream<GetObjectResponse>)((ResponseInputStream)result.result()), url);
            });
        });
    }

    public <P> S3ObjectReference putObject(String key, InputStream in, S3ObjectMetadata objectMetadata, ProgressListener<P> progressListener, P progressContext) throws IOException {
        return (S3ObjectReference)this.performAction("putting S3 object at " + key, (client, xfer) -> {
            URL url = client.utilities().getUrl(r -> r.bucket(this.bucketName).key(key));
            UploadRequest.Builder builder = UploadRequest.builder().putObjectRequest(r -> {
                r.bucket(this.bucketName).key(key);
                Map customMap = objectMetadata.asCustomMap();
                if (!customMap.isEmpty()) {
                    LinkedHashMap<String, String> meta = new LinkedHashMap<String, String>(customMap.size());
                    for (Map.Entry me : customMap.entrySet()) {
                        if (CONTENT_DISPOSITION_KEY.equalsIgnoreCase((String)me.getKey())) {
                            r.contentDisposition(me.getValue().toString());
                            continue;
                        }
                        meta.put((String)me.getKey(), me.getValue().toString());
                    }
                    if (!meta.isEmpty()) {
                        r.metadata(meta);
                    }
                }
                if (objectMetadata.getContentType() != null) {
                    r.contentType(objectMetadata.getContentType().toString());
                }
                if (objectMetadata.getStorageClass() != null) {
                    r.storageClass(objectMetadata.getStorageClass());
                }
            }).requestBody(AsyncRequestBody.fromInputStream((InputStream)in, (Long)objectMetadata.getSize(), (ExecutorService)this.executorService));
            if (progressListener != null) {
                builder = builder.addTransferListener(new Sdk2TransferListenerAdapter<Object>(progressListener, progressContext));
            }
            UploadRequest uploadRequest = builder.build();
            Upload upload = xfer.upload(uploadRequest);
            return upload.completionFuture().thenApplyAsync(result -> {
                this.log.debug("Put S3 object {}/{}", (Object)this.bucketName, (Object)key);
                return new S3ObjectRef(key, objectMetadata.getSize(), objectMetadata.getModified(), url);
            });
        });
    }

    public Set<String> deleteObjects(Iterable<String> keys) throws IOException {
        return (Set)this.performAction("deleting S3 objects " + String.valueOf(keys), (client, xfer) -> {
            ArrayList<ObjectIdentifier> idents = new ArrayList<ObjectIdentifier>(8);
            for (String key : keys) {
                idents.add((ObjectIdentifier)ObjectIdentifier.builder().key(key).build());
            }
            if (idents.isEmpty()) {
                return CompletableFuture.completedFuture(Collections.emptySet());
            }
            Delete del = (Delete)Delete.builder().objects(idents).build();
            DeleteObjectsRequest r = (DeleteObjectsRequest)DeleteObjectsRequest.builder().bucket(this.bucketName).delete(del).build();
            CompletableFuture f = client.deleteObjects(r);
            return f.thenApplyAsync(result -> {
                this.log.debug("Delete S3 objects {}/{}", (Object)this.bucketName, (Object)keys);
                return result.deleted().stream().map(o -> o.key()).collect(Collectors.toCollection(LinkedHashSet::new));
            });
        });
    }

    private synchronized S3AsyncClient getClient() {
        S3AsyncClient client = this.s3Client;
        if (client == null) {
            S3AsyncClientBuilder builder = S3AsyncClient.builder();
            if (this.regionName != null && !this.regionName.isEmpty()) {
                builder.region(Region.of((String)this.regionName));
            }
            builder.httpClient(new NettySdkAsyncHttpService().createAsyncHttpClientFactory().build());
            builder.asyncConfiguration(async -> async.advancedOption(SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR, (Object)this.executorService));
            AwsCredentialsProvider provider = null;
            if (this.credentialsProvider != null && this.tokenCredentialsProvider != null) {
                provider = AwsCredentialsProviderChain.of((AwsCredentialsProvider[])new AwsCredentialsProvider[]{this.tokenCredentialsProvider, this.credentialsProvider});
            } else if (this.tokenCredentialsProvider != null) {
                provider = this.tokenCredentialsProvider;
            } else if (this.credentialsProvider != null) {
                provider = this.credentialsProvider;
            }
            if (provider != null) {
                builder.credentialsProvider(provider);
            }
            this.s3Client = client = (S3AsyncClient)builder.build();
            this.s3TransferManager = S3TransferManager.builder().s3Client(client).build();
        }
        return client;
    }

    public String getDisplayName() {
        return "AWS SDKv2 S3 Client";
    }

    public List<SettingSpecifier> getSettingSpecifiers() {
        ArrayList<SettingSpecifier> result = new ArrayList<SettingSpecifier>(5);
        result.add((SettingSpecifier)new BasicTextFieldSettingSpecifier("accessToken", ""));
        result.add((SettingSpecifier)new BasicTextFieldSettingSpecifier("accessSecret", "", true));
        result.add((SettingSpecifier)new BasicTextFieldSettingSpecifier("regionName", DEFAULT_REGION_NAME));
        result.add((SettingSpecifier)new BasicTextFieldSettingSpecifier("bucketName", ""));
        result.add((SettingSpecifier)new BasicTextFieldSettingSpecifier("maximumKeysPerRequest", String.valueOf(500)));
        return result;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public void setMaximumKeysPerRequest(int maximumKeysPerRequest) {
        this.maximumKeysPerRequest = maximumKeysPerRequest;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setAccessSecret(String accessSecret) {
        this.accessSecret = accessSecret;
    }
}

