/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.common.s3.sdk2;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.time.Instant;
import java.util.Date;
import net.solarnetwork.common.s3.S3Object;
import net.solarnetwork.common.s3.S3ObjectMetadata;
import org.springframework.util.MimeType;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;

public class Sdk2S3Object
implements S3Object,
S3ObjectMetadata {
    private final ResponseInputStream<GetObjectResponse> response;
    private final URL url;

    public Sdk2S3Object(ResponseInputStream<GetObjectResponse> response, URL url) {
        this.response = response;
        this.url = url;
    }

    public InputStream getInputStream() throws IOException {
        return this.response;
    }

    public S3ObjectMetadata getMetadata() {
        return this;
    }

    public URL getURL() {
        return this.url;
    }

    public Date getModified() {
        Instant ts = ((GetObjectResponse)this.response.response()).lastModified();
        return ts != null ? Date.from(ts) : null;
    }

    public long getSize() {
        Long len = ((GetObjectResponse)this.response.response()).contentLength();
        return len != null ? len : -1L;
    }

    public String getStorageClass() {
        return ((GetObjectResponse)this.response.response()).storageClassAsString();
    }

    public MimeType getContentType() {
        String type = ((GetObjectResponse)this.response.response()).contentType();
        return type != null ? MimeType.valueOf((String)type) : super.getContentType();
    }
}

