/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.common.s3.sdk2;

import java.util.OptionalDouble;
import net.solarnetwork.service.ProgressListener;
import net.solarnetwork.util.ObjectUtils;
import software.amazon.awssdk.transfer.s3.progress.TransferListener;

public class Sdk2TransferListenerAdapter<T>
implements TransferListener {
    private final ProgressListener<T> delegate;
    private final T context;

    public Sdk2TransferListenerAdapter(ProgressListener<T> delegate, T context) {
        this.delegate = (ProgressListener)ObjectUtils.requireNonNullArgument(delegate, (String)"delegate");
        this.context = ObjectUtils.requireNonNullArgument(context, (String)"context");
    }

    private void handleTransfer(TransferListener.Context.TransferInitiated context) {
        OptionalDouble amt = context.progressSnapshot().ratioTransferred();
        if (amt.isPresent()) {
            this.delegate.progressChanged(this.context, amt.getAsDouble());
        }
    }

    public void transferInitiated(TransferListener.Context.TransferInitiated context) {
        this.handleTransfer(context);
    }

    public void bytesTransferred(TransferListener.Context.BytesTransferred context) {
        this.handleTransfer((TransferListener.Context.TransferInitiated)context);
    }

    public void transferComplete(TransferListener.Context.TransferComplete context) {
        this.handleTransfer((TransferListener.Context.TransferInitiated)context);
    }

    public void transferFailed(TransferListener.Context.TransferFailed context) {
    }
}

