/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.common.tmpl.st4;

import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.compiler.CompiledST;
import org.stringtemplate.v4.misc.ErrorType;
import org.stringtemplate.v4.misc.Misc;

public class MessageSourceGroup
extends STGroup {
    private static final Logger log = LoggerFactory.getLogger(MessageSourceGroup.class);
    private final String groupName;
    private final MessageSource messageSource;

    public MessageSourceGroup(String groupName, MessageSource messageSource) {
        this(groupName, messageSource, '<', '>');
    }

    public MessageSourceGroup(String groupName, MessageSource messageSource, char delimiterStartChar, char delimiterStopChar) {
        super(delimiterStartChar, delimiterStopChar);
        if (groupName == null) {
            throw new IllegalArgumentException("The groupName argument must be provided.");
        }
        this.groupName = groupName;
        if (messageSource == null) {
            throw new IllegalArgumentException("The messageSource argument must be provided.");
        }
        this.messageSource = messageSource;
    }

    public void importTemplates(Token fileNameToken) {
        String msg = "import illegal in group files embedded in MessageSourceGroup; import " + fileNameToken.getText() + " in MessageSourceGroup " + this.getName();
        throw new UnsupportedOperationException(msg);
    }

    protected CompiledST load(String name) {
        log.debug("MessageSourceGroup.load({})", (Object)name);
        String prefix = Misc.getPrefix((String)name);
        String unqualifiedName = Misc.getFileName((String)name);
        return this.loadTemplateFile(prefix, unqualifiedName + TEMPLATE_FILE_EXTENSION);
    }

    private CompiledST loadTemplateFile(String prefix, String unqualifiedFileName) {
        String t;
        log.debug("loadTemplateFile({}) in MessageSourceGroup {} from prefix={}", new Object[]{unqualifiedFileName, this.groupName, prefix});
        try {
            t = this.messageSource.getMessage(unqualifiedFileName, null, null);
        }
        catch (NoSuchMessageException e) {
            this.errMgr.runTimeError(null, null, ErrorType.INVALID_TEMPLATE_NAME, (Throwable)e, (Object)unqualifiedFileName);
            return null;
        }
        ANTLRStringStream s = new ANTLRStringStream(t);
        s.name = unqualifiedFileName;
        return this.loadTemplateFile(prefix, unqualifiedFileName, (CharStream)s);
    }

    public String getName() {
        return this.groupName;
    }
}

