/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.common.tmpl.st4;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.solarnetwork.domain.BasicIdentity;
import net.solarnetwork.service.TemplateRenderer;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import org.stringtemplate.v4.AutoIndentWriter;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STWriter;

public class ST4TemplateRenderer
extends BasicIdentity<String>
implements TemplateRenderer {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    public static final List<MimeType> HTML = Collections.singletonList(MimeTypeUtils.TEXT_HTML);
    public static final List<MimeType> TEXT = Collections.singletonList(MimeTypeUtils.TEXT_PLAIN);
    private final STGroup group;
    private final String templateName;
    private final List<MimeType> mimeTypes;
    private final Charset charset;

    public static ST4TemplateRenderer html(String id, STGroup group, String templateName) {
        return new ST4TemplateRenderer(id, group, templateName, HTML, UTF8);
    }

    public ST4TemplateRenderer(String id, STGroup group, String templateName, List<MimeType> mimeTypes, Charset charset) {
        super((Comparable)((Object)id));
        this.group = group;
        this.templateName = templateName;
        this.mimeTypes = mimeTypes;
        this.charset = charset != null ? charset : Charset.forName("UTF-8");
    }

    public boolean supportsMimeType(MimeType mimeType) {
        for (MimeType type : this.mimeTypes) {
            if (!type.isCompatibleWith(mimeType)) continue;
            return true;
        }
        return false;
    }

    public List<MimeType> supportedMimeTypes() {
        return this.mimeTypes;
    }

    public void render(Locale locale, MimeType mimeType, Map<String, ?> parameters, OutputStream out) throws IOException {
        ST st = this.group.getInstanceOf(this.templateName);
        if (st == null) {
            String msg = String.format("Template %s not available in group %s.", this.templateName, this.group);
            throw new RuntimeException(msg);
        }
        if (parameters != null) {
            for (Map.Entry<String, ?> me : parameters.entrySet()) {
                st.add(me.getKey(), me.getValue());
            }
        }
        try (OutputStreamWriter w = new OutputStreamWriter(out, this.charset);){
            AutoIndentWriter stWriter = new AutoIndentWriter((Writer)w);
            st.write((STWriter)stWriter);
        }
    }
}

