/* ==================================================================
 * ObjectEncoder.java - 26/04/2021 11:53:30 AM
 * 
 * Copyright 2021 SolarNetwork.net Dev Team
 * 
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of 
 * the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software 
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 
 * 02111-1307 USA
 * ==================================================================
 */

package net.solarnetwork.codec;

import java.io.IOException;
import java.util.Map;
import net.solarnetwork.service.Identifiable;

/**
 * API for a service that can decode objects from alternate representations.
 * 
 * @author matt
 * @version 1.0
 * @since 1.69
 * @see ObjectEncoder
 */
public interface ObjectDecoder extends Identifiable {

	/**
	 * Encode an object into a byte array.
	 * 
	 * @param data
	 *        the data to decode
	 * @param parameters
	 *        optional parameters to pass to the decoder
	 * @return the decoded object, never {@literal null}
	 * @throws IOException
	 *         if a decoding problem occurs
	 */
	Object decodeFromBytes(byte[] data, Map<String, ?> parameters) throws IOException;

}
