/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.codec;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import java.io.IOException;
import java.io.Serializable;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.Map;
import net.solarnetwork.codec.JsonUtils;
import net.solarnetwork.domain.datum.Datum;
import net.solarnetwork.domain.datum.DatumId;
import net.solarnetwork.domain.datum.DatumSamples;
import net.solarnetwork.domain.datum.DatumSamplesType;
import net.solarnetwork.domain.datum.GeneralDatum;
import net.solarnetwork.domain.datum.ObjectDatumKind;
import net.solarnetwork.util.DateUtils;

public class BasicGeneralDatumDeserializer
extends StdScalarDeserializer<Datum>
implements Serializable {
    private static final long serialVersionUID = 3787325819424216521L;
    public static final JsonDeserializer<Datum> INSTANCE = new BasicGeneralDatumDeserializer();

    public BasicGeneralDatumDeserializer() {
        super(Datum.class);
    }

    public Datum deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken t = p.currentToken();
        if (t == JsonToken.VALUE_NULL) {
            return null;
        }
        if (p.isExpectedStartObjectToken()) {
            Instant ts = null;
            String sourceId = null;
            ObjectDatumKind kind = null;
            Long objectId = null;
            DatumSamples s = new DatumSamples();
            int nestLevel = 1;
            while ((t = p.nextToken()) != null) {
                String field;
                if (t == JsonToken.END_OBJECT) {
                    if (--nestLevel >= 1) continue;
                    break;
                }
                if (t == JsonToken.START_OBJECT) {
                    ++nestLevel;
                    continue;
                }
                if (t != JsonToken.FIELD_NAME) continue;
                switch (field = p.getCurrentName()) {
                    case "created": {
                        try {
                            t = p.nextToken();
                            if (t.isNumeric()) {
                                ts = Instant.ofEpochMilli(p.getValueAsLong());
                                break;
                            }
                            ts = DateUtils.ISO_DATE_TIME_ALT_UTC.parse((CharSequence)p.getText(), Instant::from);
                            break;
                        }
                        catch (DateTimeParseException e) {
                            throw new JsonParseException(p, "Invalid 'created' date value.", p.getCurrentLocation(), (Throwable)e);
                        }
                    }
                    case "sourceId": {
                        sourceId = p.nextTextValue();
                        break;
                    }
                    case "nodeId": {
                        objectId = p.nextLongValue(-1L);
                        kind = ObjectDatumKind.Node;
                        break;
                    }
                    case "locationId": {
                        objectId = p.nextLongValue(-1L);
                        kind = ObjectDatumKind.Location;
                        break;
                    }
                    case "i": {
                        this.parseSampleMap(p, ctxt, s, DatumSamplesType.Instantaneous);
                        break;
                    }
                    case "a": {
                        this.parseSampleMap(p, ctxt, s, DatumSamplesType.Accumulating);
                        break;
                    }
                    case "s": {
                        this.parseSampleMap(p, ctxt, s, DatumSamplesType.Status);
                        break;
                    }
                    case "t": {
                        String[] tags = JsonUtils.parseStringArray(p);
                        if (tags == null || tags.length <= 0) break;
                        for (String tag : tags) {
                            s.addTag(tag);
                        }
                        break;
                    }
                }
            }
            DatumId id = new DatumId(kind, objectId, sourceId, ts);
            return new GeneralDatum(id, s);
        }
        throw new JsonParseException(p, "Unable to parse GeneralDatum (not an object)");
    }

    private void parseSampleMap(JsonParser p, DeserializationContext ctxt, DatumSamples s, DatumSamplesType type) throws IOException {
        p.nextToken();
        Map map = (Map)p.readValueAs(JsonUtils.STRING_MAP_TYPE);
        if (map != null && !map.isEmpty()) {
            for (Map.Entry e : map.entrySet()) {
                s.putSampleValue(type, (String)e.getKey(), e.getValue());
            }
        }
    }
}

