/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.codec;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import java.io.IOException;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.Set;
import net.solarnetwork.codec.JsonUtils;
import net.solarnetwork.domain.datum.Datum;
import net.solarnetwork.domain.datum.DatumSamplesOperations;
import net.solarnetwork.domain.datum.DatumSamplesType;
import net.solarnetwork.domain.datum.ObjectDatumKind;
import net.solarnetwork.util.DateUtils;

public class BasicGeneralDatumSerializer
extends StdScalarSerializer<Datum> {
    private static final long serialVersionUID = -5820173690461042501L;
    public static final JsonSerializer<Datum> INSTANCE = new BasicGeneralDatumSerializer();

    public BasicGeneralDatumSerializer() {
        super(Datum.class);
    }

    public void serialize(Datum value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject((Object)7);
        if (value.getTimestamp() != null) {
            gen.writeStringField("created", DateUtils.ISO_DATE_TIME_ALT_UTC.format(value.getTimestamp().truncatedTo(ChronoUnit.MILLIS)));
        }
        if (value.getSourceId() != null) {
            gen.writeStringField("sourceId", value.getSourceId());
        }
        if (value.getKind() == ObjectDatumKind.Location && value.getObjectId() != null) {
            gen.writeNumberField("locationId", value.getObjectId().longValue());
        }
        DatumSamplesOperations ops = value.asSampleOperations();
        for (DatumSamplesType t : DatumSamplesType.values()) {
            if (t == DatumSamplesType.Tag) {
                Set<String> tags = ops.getTags();
                if (tags == null || tags.isEmpty()) continue;
                String[] tagsArray = tags.toArray(new String[tags.size()]);
                JsonUtils.writeStringArrayField(gen, "t", tagsArray);
                continue;
            }
            Map<String, ?> data = ops.getSampleData(t);
            if (data == null || data.isEmpty()) continue;
            gen.writeObjectField(String.valueOf(t.toKey()), data);
        }
        gen.writeEndObject();
    }
}

