/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.codec;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import java.io.IOException;
import java.io.Serializable;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import net.solarnetwork.codec.BasicInstructionField;
import net.solarnetwork.codec.BasicInstructionStatusField;
import net.solarnetwork.domain.BasicInstruction;
import net.solarnetwork.domain.BasicInstructionStatus;
import net.solarnetwork.domain.Instruction;
import net.solarnetwork.domain.InstructionStatus;

public class BasicInstructionDeserializer
extends StdScalarDeserializer<Instruction>
implements Serializable {
    private static final long serialVersionUID = -1844182290390256234L;
    public static final JsonDeserializer<Instruction> INSTANCE = new BasicInstructionDeserializer();

    public BasicInstructionDeserializer() {
        super(Instruction.class);
    }

    public BasicInstruction deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken t = p.currentToken();
        if (t == JsonToken.VALUE_NULL) {
            return null;
        }
        if (p.isExpectedStartObjectToken()) {
            String f;
            Long id = null;
            String topic = null;
            Instant date = null;
            Map parameters = null;
            InstructionStatus status = null;
            InstructionStatus.InstructionState state = null;
            Instant statusDate = null;
            Map resultParameters = null;
            while ((f = p.nextFieldName()) != null) {
                BasicInstructionField field = BasicInstructionField.FIELD_MAP.get(f);
                if (field == null) {
                    BasicInstructionStatusField statusField = BasicInstructionStatusField.FIELD_MAP.get(f);
                    if (statusField != null) {
                        Object v = statusField.parseValue(p, ctxt);
                        switch (statusField) {
                            case InstructionState: {
                                state = (InstructionStatus.InstructionState)((Object)v);
                                break;
                            }
                            case StatusDate: {
                                statusDate = (Instant)v;
                                break;
                            }
                            case ResultParameters: {
                                resultParameters = (Map)v;
                                break;
                            }
                        }
                        continue;
                    }
                    p.nextToken();
                    continue;
                }
                Object v = field.parseValue(p, ctxt);
                switch (field) {
                    case Id: {
                        id = (Long)v;
                        break;
                    }
                    case Topic: {
                        topic = (String)v;
                        break;
                    }
                    case InstructionDate: {
                        date = (Instant)v;
                        break;
                    }
                    case Params: 
                    case Parameters: {
                        parameters = (Map)v;
                        break;
                    }
                    case Status: {
                        status = (InstructionStatus)v;
                    }
                }
            }
            while ((t = p.currentToken()) != JsonToken.END_OBJECT) {
                t = p.nextToken();
            }
            if (status == null && state != null) {
                status = new BasicInstructionStatus(id, state, statusDate, resultParameters);
            }
            BasicInstruction result = new BasicInstruction(id, topic, date != null ? date : Instant.now(), status);
            if (parameters != null) {
                for (Map.Entry e : parameters.entrySet()) {
                    String paramName = (String)e.getKey();
                    for (String paramValue : (List)e.getValue()) {
                        result.addParameter(paramName, paramValue);
                    }
                }
            }
            return result;
        }
        throw new JsonParseException(p, "Unable to parse Instruction (not an object)");
    }
}

