/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.codec;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.solarnetwork.codec.BasicInstructionStatusDeserializer;
import net.solarnetwork.codec.BasicInstructionStatusSerializer;
import net.solarnetwork.codec.IndexedField;
import net.solarnetwork.codec.JsonDateUtils;
import net.solarnetwork.domain.InstructionStatus;

public final class BasicInstructionField
extends Enum<BasicInstructionField>
implements IndexedField {
    public static final /* enum */ BasicInstructionField Topic = new BasicInstructionField(0, "topic");
    public static final /* enum */ BasicInstructionField Id = new BasicInstructionField(1, "id");
    public static final /* enum */ BasicInstructionField InstructionDate = new BasicInstructionField(2, "instructionDate");
    public static final /* enum */ BasicInstructionField Params = new BasicInstructionField(3, "params");
    public static final /* enum */ BasicInstructionField Parameters = new BasicInstructionField(4, "parameters");
    public static final /* enum */ BasicInstructionField Status = new BasicInstructionField(5, "status");
    public static final Map<String, BasicInstructionField> FIELD_MAP;
    private final int index;
    private final String fieldName;
    private static final /* synthetic */ BasicInstructionField[] $VALUES;

    public static BasicInstructionField[] values() {
        return (BasicInstructionField[])$VALUES.clone();
    }

    public static BasicInstructionField valueOf(String name) {
        return Enum.valueOf(BasicInstructionField.class, name);
    }

    private BasicInstructionField(int index, String fieldName) {
        this.index = index;
        this.fieldName = fieldName;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public Object parseValue(JsonParser parser, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        switch (this) {
            case Id: {
                parser.nextToken();
                return parser.getLongValue();
            }
            case Topic: {
                return parser.nextTextValue();
            }
            case InstructionDate: {
                parser.nextToken();
                return JsonDateUtils.InstantDeserializer.INSTANCE.deserialize(parser, ctxt);
            }
            case Params: 
            case Parameters: {
                return BasicInstructionField.parseParameters(parser, ctxt);
            }
            case Status: {
                parser.nextToken();
                return BasicInstructionStatusDeserializer.INSTANCE.deserialize(parser, ctxt);
            }
        }
        return null;
    }

    @Override
    public void writeValue(JsonGenerator generator, SerializerProvider provider, Object value) throws IOException, JsonProcessingException {
        if (value == null) {
            return;
        }
        switch (this) {
            case Id: {
                generator.writeNumberField(this.fieldName, ((Number)value).longValue());
                break;
            }
            case Topic: {
                generator.writeStringField(this.fieldName, value.toString());
                break;
            }
            case InstructionDate: {
                generator.writeFieldName(this.fieldName);
                JsonDateUtils.InstantSerializer.INSTANCE.serialize((Object)((Instant)value), generator, provider);
                break;
            }
            case Params: 
            case Parameters: {
                this.writeParameters((Map)value, generator, provider);
                break;
            }
            case Status: {
                BasicInstructionStatusSerializer.EMBEDDED_INSTANCE.serialize((Object)((InstructionStatus)value), generator, provider);
                break;
            }
        }
    }

    private static Map<String, List<String>> parseParameters(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t = p.nextToken();
        switch (t) {
            case START_ARRAY: {
                return BasicInstructionField.parseParameterList(p, ctxt);
            }
            case START_OBJECT: {
                return BasicInstructionField.parseParameterMap(p, ctxt);
            }
        }
        return null;
    }

    private static Map<String, List<String>> parseParameterList(JsonParser p, DeserializationContext ctxt) throws IOException {
        assert (p.currentToken() == JsonToken.START_ARRAY);
        LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>(8);
        JsonToken t = null;
        String paramName = null;
        String paramValue = null;
        while ((t = p.nextToken()) != JsonToken.END_ARRAY) {
            String f;
            if (t != JsonToken.START_OBJECT) continue;
            while ((f = p.nextFieldName()) != null) {
                String v = p.nextTextValue();
                switch (f) {
                    case "name": {
                        paramName = v;
                        break;
                    }
                    case "value": {
                        paramValue = v;
                    }
                }
            }
            if (paramName == null || paramValue == null) continue;
            result.computeIfAbsent(paramName, k -> new ArrayList(1)).add(paramValue);
        }
        return result;
    }

    private static Map<String, List<String>> parseParameterMap(JsonParser p, DeserializationContext ctxt) throws IOException {
        String f;
        assert (p.currentToken() == JsonToken.START_OBJECT);
        LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>(8);
        while ((f = p.nextFieldName()) != null) {
            String s = p.nextTextValue();
            if (s == null) continue;
            result.computeIfAbsent(f, k -> new ArrayList(1)).add(s);
        }
        return result;
    }

    private void writeParameters(Map<String, List<String>> value, JsonGenerator generator, SerializerProvider provider) throws IOException {
        if (value == null || value.isEmpty()) {
            return;
        }
        generator.writeFieldName(this.fieldName);
        switch (this) {
            case Params: {
                BasicInstructionField.writeParameterList(value, generator, provider);
                break;
            }
            case Parameters: {
                BasicInstructionField.writeParameterMap(value, generator, provider);
                break;
            }
        }
    }

    private static void writeParameterList(Map<String, List<String>> value, JsonGenerator generator, SerializerProvider provider) throws IOException {
        assert (value != null);
        int size = 0;
        for (List<String> list : value.values()) {
            size += list.size();
        }
        generator.writeStartArray(size);
        for (Map.Entry entry : value.entrySet()) {
            for (String v : (List)entry.getValue()) {
                generator.writeStartObject();
                generator.writeStringField("name", (String)entry.getKey());
                generator.writeStringField("value", v);
                generator.writeEndObject();
            }
        }
        generator.writeEndArray();
    }

    private static void writeParameterMap(Map<String, List<String>> value, JsonGenerator generator, SerializerProvider provider) throws IOException {
        assert (value != null);
        generator.writeStartObject(value, value.size());
        for (Map.Entry<String, List<String>> me : value.entrySet()) {
            String v;
            String string = v = me.getValue() != null && !me.getValue().isEmpty() ? me.getValue().get(0) : null;
            if (v == null) continue;
            generator.writeStringField(me.getKey(), v);
        }
        generator.writeEndObject();
    }

    private static /* synthetic */ BasicInstructionField[] $values() {
        return new BasicInstructionField[]{Topic, Id, InstructionDate, Params, Parameters, Status};
    }

    static {
        $VALUES = BasicInstructionField.$values();
        FIELD_MAP = IndexedField.fieldMap(BasicInstructionField.class);
    }
}

