/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.codec;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import java.io.IOException;
import java.io.Serializable;
import java.time.Instant;
import java.util.Map;
import net.solarnetwork.codec.BasicInstructionStatusField;
import net.solarnetwork.domain.BasicInstructionStatus;
import net.solarnetwork.domain.InstructionStatus;

public class BasicInstructionStatusDeserializer
extends StdScalarDeserializer<InstructionStatus>
implements Serializable {
    private static final long serialVersionUID = -5321961973815076686L;
    public static final JsonDeserializer<InstructionStatus> INSTANCE = new BasicInstructionStatusDeserializer();

    public BasicInstructionStatusDeserializer() {
        super(InstructionStatus.class);
    }

    public InstructionStatus deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken t = p.currentToken();
        if (t == JsonToken.VALUE_NULL) {
            return null;
        }
        if (p.isExpectedStartObjectToken()) {
            String f;
            Long id = null;
            InstructionStatus.InstructionState state = null;
            Instant statusDate = null;
            Map resultParameters = null;
            while ((f = p.nextFieldName()) != null) {
                BasicInstructionStatusField statusField = BasicInstructionStatusField.FIELD_MAP.get(f);
                if (statusField == null) {
                    p.nextToken();
                    continue;
                }
                Object v = statusField.parseValue(p, ctxt);
                switch (statusField) {
                    case InstructionId: {
                        id = (Long)v;
                        break;
                    }
                    case InstructionState: {
                        state = (InstructionStatus.InstructionState)((Object)v);
                        break;
                    }
                    case StatusDate: {
                        statusDate = (Instant)v;
                        break;
                    }
                    case ResultParameters: {
                        resultParameters = (Map)v;
                    }
                }
            }
            while ((t = p.currentToken()) != JsonToken.END_OBJECT) {
                t = p.nextToken();
            }
            return new BasicInstructionStatus(id, state, statusDate, resultParameters);
        }
        throw new JsonParseException(p, "Unable to parse Instruction (not an object)");
    }
}

